/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.gems;

import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=GemManager.class)
public class DefaultGemManager
implements GemManager {
    private static final String DEFAULT_GEMS_REPOSITORY_BASE_URL = "http://gems.saumya.de/";
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    private ProjectBuilder builder;

    private Artifact setLatestVersionIfMissing(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        if (artifact.getVersion() == null) {
            List<String> versions = this.availableVersions(artifact, localRepository, remoteRepositories);
            artifact.setVersionRange(null);
            artifact.setVersion(versions.get(versions.size() - 1));
        }
        return artifact;
    }

    @Override
    public Artifact createGemArtifact(String gemname) throws GemException {
        return this.createGemArtifact(gemname, null);
    }

    @Override
    public Artifact createGemArtifact(String gemname, String version) throws GemException {
        return this.createArtifact("rubygems", gemname, version, "gem");
    }

    @Override
    public Artifact createGemArtifactWithLatestVersion(String gemname, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        Artifact gem = this.createGemArtifact(gemname, null);
        this.setLatestVersionIfMissing(gem, localRepository, remoteRepositories);
        return gem;
    }

    @Override
    public ArtifactRepository defaultGemArtifactRepository() {
        return this.defaultGemArtifactRepositoryForVersion("0.0.0");
    }

    @Override
    public ArtifactRepository defaultGemArtifactRepositoryForVersion(String artifactVersion) {
        String preRelease = artifactVersion != null && artifactVersion.matches(".*[a-z][A-Z].*") ? "pre" : "";
        return this.repositorySystem.createArtifactRepository("rubygems-" + preRelease + "releases", DEFAULT_GEMS_REPOSITORY_BASE_URL + preRelease + "releases", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
    }

    @Override
    public void addDefaultGemRepository(List<ArtifactRepository> repos) {
        this.addDefaultGemRepositoryForVersion("0.0.0", repos);
    }

    @Override
    public void addDefaultGemRepositoryForVersion(String artifactVersion, List<ArtifactRepository> repos) {
        ArtifactRepository repo = this.defaultGemArtifactRepositoryForVersion(artifactVersion);
        for (ArtifactRepository ar : repos) {
            if (!ar.getUrl().equals(repo.getUrl())) continue;
            return;
        }
        repos.add(repo);
    }

    @Override
    public Artifact createJarArtifactForGemname(String gemName) throws GemException {
        return this.createJarArtifactForGemname(gemName, null);
    }

    @Override
    public Artifact createJarArtifactForGemname(String gemName, String version) throws GemException {
        int index = gemName.lastIndexOf(":");
        String groupId = gemName.substring(0, index);
        String artifactId = gemName.substring(index + 1);
        return this.createArtifact(groupId, artifactId, version, "jar");
    }

    @Override
    public Artifact createJarArtifactForGemnameWithLatestVersion(String gemName, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        Artifact artifact = this.createJarArtifactForGemname(gemName, null);
        this.setLatestVersionIfMissing(artifact, localRepository, remoteRepositories);
        return artifact;
    }

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        Dependency dep = new Dependency();
        dep.setGroupId(groupId);
        dep.setArtifactId(artifactId);
        dep.setType(type);
        dep.setVersion(version == null ? "[0,)" : version);
        return this.repositorySystem.createDependencyArtifact(dep);
    }

    @Override
    public void resolve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        if (artifact.getFile() == null || !artifact.getFile().exists()) {
            Set artifacts = this.repositorySystem.resolve(new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(localRepository).setRemoteRepositories(remoteRepositories)).getArtifacts();
            if (artifacts.size() == 0) {
                throw new GemException("could not resolve artifact: " + artifact);
            }
            artifact.setFile(((Artifact)artifacts.iterator().next()).getFile());
        }
    }

    @Override
    public MavenProject buildModel(Artifact artifact, RepositorySystemSession repositorySystemSession, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, boolean resolve) throws GemException {
        ProjectBuildingRequest pomRequest = new DefaultProjectBuildingRequest().setLocalRepository(localRepository).setRemoteRepositories(remoteRepositories).setValidationLevel(30).setRepositorySession(repositorySystemSession).setResolveDependencies(resolve);
        try {
            return this.builder.build(artifact, pomRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new GemException("error building POM", (Exception)((Object)e));
        }
    }

    @Override
    public MavenProject buildPom(Artifact artifact, RepositorySystemSession repositorySystemSession, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        MavenProject pom = this.buildModel(artifact, repositorySystemSession, localRepository, remoteRepositories, true);
        this.resolve(pom.getArtifact(), localRepository, remoteRepositories);
        return pom;
    }

    @Override
    public String latestVersion(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        List<String> versions = this.availableVersions(artifact, localRepository, remoteRepositories);
        return versions.get(versions.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> availableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        ArrayList<String> versions;
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(request.getArtifact());
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, (RepositoryRequest)request);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new GemException("error updateding versions of artifact: " + artifact, (Exception)((Object)e));
        }
        if (metadata.getMetadata().getVersioning() == null) {
            if (remoteRepositories.size() == 0) {
                throw new GemException("no version found - maybe system is offline or wrong <groupId:artifactId>: " + artifact.getGroupId() + ":" + artifact.getArtifactId());
            }
            versions = new ArrayList<String>();
        } else {
            versions = metadata.getMetadata().getVersioning().getVersions();
        }
        Iterator<ArtifactRepository> i$ = remoteRepositories.iterator();
        while (true) {
            if (!i$.hasNext()) {
                Collections.sort(versions);
                return versions;
            }
            ArtifactRepository repo = i$.next();
            BufferedReader reader = null;
            try {
                URL url = new URL(repo.getUrl() + "/" + artifact.getGroupId().replace(".", "/") + "/" + artifact.getArtifactId() + "/");
                reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    String version;
                    if (line.contains("<a href=") && (version = line.replaceFirst(".*<a href=\".*\">", "").replaceFirst("</a>.*", "")).endsWith("/") && !versions.contains(version = version.substring(0, version.length() - 1))) {
                        versions.add(version);
                    }
                    line = reader.readLine();
                }
                IOUtil.close((Reader)reader);
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("error scraping versions from html page", e);
                catch (IOException e2) {
                    continue;
                }
            }
            finally {
                IOUtil.close(reader);
                continue;
            }
            break;
        }
    }
}

