/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gems;

import de.saumya.mojo.gems.GemArtifact;
import de.saumya.mojo.gems.Maven2GemVersionConverter;
import de.saumya.mojo.gems.MavenArtifact;
import de.saumya.mojo.gems.MavenArtifactConverter;
import de.saumya.mojo.gems.gem.Gem;
import de.saumya.mojo.gems.gem.GemPackager;
import de.saumya.mojo.gems.spec.GemDependency;
import de.saumya.mojo.gems.spec.GemRequirement;
import de.saumya.mojo.gems.spec.GemSpecification;
import de.saumya.mojo.gems.spec.GemSpecificationIO;
import de.saumya.mojo.gems.spec.GemVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.License;
import org.apache.maven.model.Relocation;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

@Component(role=MavenArtifactConverter.class)
public class DefaultMavenArtifactConverter
implements MavenArtifactConverter {
    private static final String LIB_PATH = "lib/";
    private static final String LIB_MAVEN_PATH = "lib/maven/";
    String PLATFORM_JAVA = "java";
    @Requirement
    private GemPackager gemPackager;
    @Requirement
    private VelocityComponent velocityComponent;
    @Requirement(hints={"yaml"})
    private GemSpecificationIO gemSpecificationIO;
    private final Maven2GemVersionConverter maven2GemVersionConverter = new Maven2GemVersionConverter();

    public boolean canConvert(MavenArtifact artifact) {
        if (this.canConvert(artifact, "pom", null)) {
            return true;
        }
        return this.canConvert(artifact, artifact.getPom().getPackaging(), "jar");
    }

    private boolean canConvert(MavenArtifact artifact, String packaging, String extension) {
        String fixedExtension = null;
        if (extension != null) {
            fixedExtension = extension.startsWith(".") ? extension : "." + extension;
        }
        return StringUtils.equals((String)packaging, (String)artifact.getPom().getPackaging()) && (extension == null && artifact.getArtifactFile() == null || extension != null && artifact.getArtifactFile() != null && artifact.getArtifactFile().getName().endsWith(fixedExtension));
    }

    public String getGemFileName(MavenArtifact artifact) {
        return this.getGemFileName(artifact.getCoordinates().getGroupId(), artifact.getCoordinates().getArtifactId(), artifact.getCoordinates().getVersion(), this.PLATFORM_JAVA);
    }

    public GemSpecification createSpecification(MavenArtifact artifact) {
        Relocation relocation;
        GemSpecification result = new GemSpecification();
        result.setPlatform(this.PLATFORM_JAVA);
        result.setName(this.createGemName(artifact.getCoordinates().getGroupId(), artifact.getCoordinates().getArtifactId(), artifact.getCoordinates().getVersion()));
        result.setVersion(new GemVersion(this.createGemVersion(artifact.getCoordinates().getVersion())));
        if (artifact.getPom().getDependencies().size() > 0) {
            for (Dependency dependency : artifact.getPom().getDependencies()) {
                if (dependency.isOptional()) continue;
                result.getDependencies().add(this.convertDependency(artifact, dependency));
            }
        }
        if (artifact.getPom().getDistributionManagement() != null && (relocation = artifact.getPom().getDistributionManagement().getRelocation()) != null) {
            result.getDependencies().clear();
            Dependency dep = new Dependency();
            dep.setVersion(relocation.getVersion() == null ? artifact.getPom().getVersion() : relocation.getVersion());
            dep.setArtifactId(relocation.getArtifactId() == null ? artifact.getPom().getArtifactId() : relocation.getArtifactId());
            dep.setGroupId(relocation.getGroupId() == null ? artifact.getPom().getGroupId() : relocation.getGroupId());
            result.getDependencies().add(this.convertDependency(artifact, dep));
            result.setPost_install_message("this gem has a new name: " + this.createGemName(dep.getGroupId(), dep.getArtifactId(), dep.getVersion()) + " version: " + dep.getVersion());
        }
        result.setDate(new Date());
        result.setDescription(this.sanitizeStringValue(artifact.getPom().getDescription() != null ? artifact.getPom().getDescription() : artifact.getPom().getName()));
        result.setSummary(this.sanitizeStringValue(artifact.getPom().getName()));
        result.setHomepage(this.sanitizeStringValue(artifact.getPom().getUrl()));
        if (artifact.getPom().getLicenses().size() > 0) {
            for (License license : artifact.getPom().getLicenses()) {
                result.getLicenses().add(this.sanitizeStringValue(license.getName() + " (" + license.getUrl() + ")"));
            }
        }
        if (artifact.getPom().getDevelopers().size() > 0) {
            for (Developer developer : artifact.getPom().getDevelopers()) {
                result.getAuthors().add(this.sanitizeStringValue(developer.getName() + " (" + developer.getEmail() + ")"));
            }
        }
        result.getRequire_paths().add("lib");
        return result;
    }

    public GemArtifact createGemStubFromArtifact(MavenArtifact artifact, File target) throws IOException {
        GemSpecification gemspec = this.createSpecification(artifact);
        if (target == null) {
            throw new IOException("Must specify target file, where to generate Gem!");
        }
        File gemfile = this.gemPackager.createGemStub(gemspec, target);
        return new GemArtifact(gemspec, gemfile);
    }

    public GemArtifact createGemFromArtifact(MavenArtifact artifact, File target) throws IOException {
        GemSpecification gemspec = this.createSpecification(artifact);
        if (target == null || target.exists() && !target.isDirectory()) {
            throw new IOException("Must specify target directory, where to generate Gem!");
        }
        Gem gem = new Gem(gemspec);
        if (artifact.getArtifactFile() != null) {
            gem.addFile(artifact.getArtifactFile(), this.createLibFileName(artifact, ".jar"));
        }
        String rubyStubMetaPath = this.createLibFileName(artifact, "-maven.rb");
        File rubyStubMetaFile = this.generateRubyMetaStub(gemspec, artifact);
        gem.addFile(rubyStubMetaFile, rubyStubMetaPath);
        String rubyStubPath = this.createLibFileName(artifact, ".rb");
        File rubyStubFile = this.generateRubyStub(gemspec, artifact, RubyDependencyType.RUNTIME);
        gem.addFile(rubyStubFile, rubyStubPath);
        String rubyDevelopmentStubPath = this.createLibFileName(artifact, "-dev.rb");
        File rubyDevelopmentStubFile = this.generateRubyStub(gemspec, artifact, RubyDependencyType.DEVELOPMENT);
        gem.addFile(rubyDevelopmentStubFile, rubyDevelopmentStubPath);
        File rubyMainStubFile = this.generateMainStub(artifact);
        gem.addFile(rubyMainStubFile, LIB_PATH + gemspec.getName() + ".rb");
        File gemfile = this.gemPackager.createGem(gem, target);
        return new GemArtifact(gemspec, gemfile);
    }

    protected String sanitizeStringValue(String val) {
        if (val == null) {
            return null;
        }
        return val.replaceAll("'", "").replaceAll("\"", "").replace('\n', ' ');
    }

    protected String createLibFileName(MavenArtifact artifact, String postfix) {
        return LIB_MAVEN_PATH + this.createRequireName(artifact.getCoordinates().getGroupId(), artifact.getCoordinates().getArtifactId(), artifact.getCoordinates().getVersion()) + postfix;
    }

    protected String createRequireName(String groupId, String artifactId, String version) {
        return groupId + "/" + artifactId;
    }

    protected String createJarfileName(String groupId, String artifactId, String version) {
        return artifactId + ".jar";
    }

    protected String createGemName(String groupId, String artifactId, String version) {
        return "mvn:" + groupId + ":" + artifactId;
    }

    protected String getGemFileName(String groupId, String artifactId, String version, String platform) {
        String gemName = this.createGemName(groupId, artifactId, version);
        String gemVersion = this.createGemVersion(version);
        return Gem.constructGemFileName(gemName, gemVersion, platform);
    }

    protected String getGemFileName(GemSpecification gemspec) {
        return Gem.constructGemFileName(gemspec.getName(), gemspec.getVersion().getVersion(), gemspec.getPlatform());
    }

    protected String createGemVersion(String mavenVersion) throws NullPointerException {
        return this.maven2GemVersionConverter.createGemVersion(mavenVersion);
    }

    private File generateMainStub(MavenArtifact artifact) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("groupId", (Object)artifact.getCoordinates().getGroupId());
        context.put("artifactId", (Object)artifact.getCoordinates().getArtifactId());
        return this.generateRubyFile("main", (Context)context, "rubyMainStub");
    }

    private File generateRubyMetaStub(GemSpecification gemspec, MavenArtifact artifact) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("gemVersion", (Object)gemspec.getVersion().getVersion());
        context.put("groupId", (Object)artifact.getCoordinates().getGroupId());
        context.put("artifactId", (Object)artifact.getCoordinates().getArtifactId());
        context.put("type", (Object)artifact.getPom().getPackaging());
        context.put("version", (Object)artifact.getCoordinates().getVersion());
        if (artifact.getArtifactFile() != null) {
            context.put("filename", (Object)this.createJarfileName(artifact.getCoordinates().getGroupId(), artifact.getCoordinates().getArtifactId(), artifact.getCoordinates().getVersion()));
        }
        ArrayList<String> packageParts = new ArrayList<String>();
        for (String part : artifact.getCoordinates().getGroupId().split("\\.")) {
            packageParts.add(this.titleize(part));
        }
        packageParts.add(this.titleize(artifact.getCoordinates().getArtifactId()));
        context.put("packageParts", packageParts);
        return this.generateRubyFile("metafile", (Context)context, "rubyMetaStub");
    }

    private File generateRubyStub(GemSpecification gemspec, MavenArtifact artifact, RubyDependencyType type) throws IOException {
        VelocityContext context = new VelocityContext();
        switch (type) {
            case RUNTIME: {
                if (artifact.getArtifactFile() == null) break;
                context.put("jarfile", (Object)this.createJarfileName(artifact.getCoordinates().getGroupId(), artifact.getCoordinates().getArtifactId(), artifact.getCoordinates().getVersion()));
                break;
            }
            case DEVELOPMENT: {
                context.put("filename", (Object)(artifact.getCoordinates().getArtifactId() + ".rb"));
            }
        }
        ArrayList<MavenDependency> deps = new ArrayList<MavenDependency>();
        for (Dependency dependency : artifact.getPom().getDependencies()) {
            if (RubyDependencyType.toRubyDependencyType(dependency.getScope()) != type || dependency.isOptional()) continue;
            MavenDependency mavenDependency = new MavenDependency();
            mavenDependency.name = this.createRequireName(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            for (Exclusion exclusion : dependency.getExclusions()) {
                mavenDependency.exclusions.add(exclusion.getGroupId() + "/" + exclusion.getArtifactId());
            }
            deps.add(mavenDependency);
        }
        context.put("dependencies", deps);
        return this.generateRubyFile("require" + type.name(), (Context)context, "rubyStub" + type.name());
    }

    private File generateRubyFile(String templateName, Context context, String stubFilename) throws IOException {
        InputStream input = this.getClass().getResourceAsStream("/" + templateName + ".rb.vm");
        if (input == null) {
            throw new FileNotFoundException(templateName + ".rb.vm");
        }
        String rubyTemplate = IOUtil.toString((InputStream)input);
        File rubyFile = File.createTempFile(stubFilename, ".rb.tmp");
        FileWriter fw = new FileWriter(rubyFile);
        this.velocityComponent.getEngine().evaluate(context, (Writer)fw, "ruby", rubyTemplate);
        fw.flush();
        fw.close();
        return rubyFile;
    }

    private String titleize(String string) {
        String[] titleParts = string.split("[-._]");
        StringBuilder titleizedString = new StringBuilder();
        for (String part : titleParts) {
            if (part == null || part.length() == 0) continue;
            titleizedString.append(StringUtils.capitalise((String)part));
        }
        return titleizedString.toString();
    }

    private GemDependency convertDependency(MavenArtifact artifact, Dependency dependency) {
        GemDependency result = new GemDependency();
        result.setName(this.createGemName(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
        result.setType(RubyDependencyType.toRubyDependencyType(dependency.getScope()).toString());
        GemRequirement requirement = new GemRequirement();
        String version = this.createGemVersion(this.getDependencyVersion(artifact, dependency));
        GemVersion gemVersion = version.matches("^[^.]+\\.[^.]+\\..*") ? new GemVersion(version.substring(0, version.indexOf(46)) + ".0.a") : new GemVersion(version);
        requirement.addRequirement("~>", gemVersion);
        result.setVersion_requirement(requirement);
        return result;
    }

    private String getDependencyVersion(MavenArtifact artifact, Dependency dependency) {
        if (dependency.getVersion() != null) {
            return dependency.getVersion();
        }
        if (StringUtils.equals((String)artifact.getCoordinates().getGroupId(), (String)dependency.getGroupId())) {
            return artifact.getCoordinates().getVersion();
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createGemspecFromArtifact(MavenArtifact artifact, File target) throws IOException {
        GemSpecification gemspec = this.createSpecification(artifact);
        File targetFile = new File(target, this.getGemFileName(gemspec) + "spec");
        FileWriter writer = null;
        try {
            writer = new FileWriter(targetFile);
            writer.append(this.gemSpecificationIO.write(gemspec));
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        return targetFile;
    }

    public static class MavenDependency {
        public String name;
        public List<String> exclusions = new ArrayList<String>();

        public String getName() {
            return this.name;
        }

        public String getExclusions() {
            StringBuilder buf = new StringBuilder();
            for (String ex : this.exclusions) {
                buf.append(",'").append(ex).append("'");
            }
            return this.exclusions.size() > 0 ? buf.substring(1) : "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RubyDependencyType {
        RUNTIME,
        DEVELOPMENT;


        public String toString() {
            return ":" + this.name().toLowerCase();
        }

        public static RubyDependencyType toRubyDependencyType(String dependencyScope) {
            if ("provided".equals(dependencyScope) || "test".equals(dependencyScope)) {
                return DEVELOPMENT;
            }
            if ("compile".equals(dependencyScope) || "runtime".equals(dependencyScope)) {
                return RUNTIME;
            }
            return RUNTIME;
        }
    }
}

