/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import de.saumya.mojo.ruby.AntLauncher;
import de.saumya.mojo.ruby.Arguments;
import de.saumya.mojo.ruby.EmbeddedLauncher;
import de.saumya.mojo.ruby.Launcher;
import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.RubyScriptException;
import de.saumya.mojo.ruby.Script;
import de.saumya.mojo.ruby.ScriptUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFactory {
    public static List<String> NO_CLASSPATH = Collections.emptyList();
    final Arguments switches = new Arguments();
    final Arguments javaArgs = new Arguments();
    final Map<String, String> env = new HashMap<String, String>();
    final Logger logger;
    final ClassRealm classRealm;
    final File jrubyJar;
    final List<String> classpathElements;
    final boolean fork;
    final Launcher launcher;

    public ScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, List<String> classpathElements, boolean fork) throws RubyScriptException, IOException {
        this.logger = logger;
        this.classRealm = classRealm;
        this.jrubyJar = jrubyJar;
        this.classpathElements = classpathElements == null ? NO_CLASSPATH : Collections.unmodifiableList(classpathElements);
        this.fork = fork;
        if (fork) {
            this.launcher = new AntLauncher(logger, this);
        } else {
            if (classRealm != null) {
                try {
                    ClassRealm jruby = classRealm.getWorld().getRealm("jruby");
                }
                catch (NoSuchRealmException e) {
                    try {
                        ClassRealm jruby = classRealm.getParent().createChildRealm("jruby");
                        jruby.addConstituent(jrubyJar.toURI().toURL());
                    }
                    catch (DuplicateRealmException ee) {
                        throw new RubyScriptException("could not setup classrealm for jruby", (Exception)((Object)ee));
                    }
                }
            }
            this.launcher = new EmbeddedLauncher(logger, this);
        }
    }

    public Script newScriptFromSearchPath(String scriptName) throws IOException {
        return new Script(this, scriptName, true);
    }

    public Script newScriptFromResource(String scriptName) throws IOException {
        URL url;
        URL uRL = url = this.classRealm != null ? this.classRealm.getClassLoader().getResource(scriptName) : null;
        if (url == null) {
            url = ScriptUtils.getScriptFromResource(scriptName);
        }
        if (url.getProtocol().equals("file")) {
            return new Script(this, url.getPath(), false);
        }
        return new Script(this, url);
    }

    public Script newArguments() {
        return new Script(this);
    }

    public Script newScript(String script) throws IOException {
        return new Script(this, script);
    }

    public Script newScript(File file) {
        return new Script(this, file);
    }

    public void addJavaOption(String name) {
        this.javaArgs.add(name);
    }

    public void addJavaOption(String name, String value) {
        this.javaArgs.add(name, value);
    }

    public void addJavaProperty(String name, String value) {
        this.javaArgs.add("-D" + name + "=" + value);
    }

    public void addJavaArgs(String args) {
        this.javaArgs.parseAndAdd(args);
    }

    public void addSwitch(String name) {
        this.switches.add(name);
    }

    public void addSwitch(String name, String value) {
        this.switches.add(name, value);
    }

    public void addSwitches(String switches) {
        this.switches.parseAndAdd(switches);
    }

    public void addEnv(String name, File value) {
        if (value != null) {
            this.env.put(name, value.getAbsolutePath());
        }
    }

    public void addEnv(String name, String value) {
        if (value != null) {
            this.env.put(name, value);
        }
    }

    public void addEnvs(String environmentVars) {
        for (String var : environmentVars.split("\\s+")) {
            int index = var.indexOf("=");
            if (index <= -1) continue;
            this.env.put(var.substring(0, index), var.substring(index + 1));
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        return buf.toString().trim();
    }
}

