/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import de.saumya.mojo.ruby.GemService;
import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.RubyScriptException;
import de.saumya.mojo.ruby.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemScriptFactory
extends ScriptFactory
implements GemService {
    public static final String GEM_HOME = "GEM_HOME";
    public static final String GEM_PATH = "GEM_PATH";
    private final File gemHome;
    private final File gemPath;

    public GemScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, List<String> classpathElements, boolean fork, File gemHome, File gemPath) throws RubyScriptException, IOException {
        super(logger, classRealm, jrubyJar, classpathElements, fork);
        this.gemHome = new File(gemHome.getAbsolutePath().replaceFirst(".*/[$][{]project.basedir[}]/", ""));
        if (this.gemHome != null) {
            this.addEnv(GEM_HOME, this.gemHome.getPath());
        }
        this.gemPath = new File(gemPath.getAbsolutePath().replaceFirst(".*/[$][{]project.basedir[}]/", ""));
        if (this.gemPath != null) {
            this.addEnv(GEM_PATH, this.gemPath.getPath());
        }
    }

    @Override
    public File binDirectory() throws RubyScriptException {
        if (this.gemHome == null) {
            if (System.getenv(GEM_HOME) == null) {
                throw new RubyScriptException("no GEM_HOME set");
            }
            return new File(System.getenv(GEM_HOME), "bin");
        }
        return new File(this.gemHome, "bin");
    }

    @Override
    public File gemDirectory() throws RubyScriptException {
        if (this.gemPath == null) {
            if (System.getenv(GEM_PATH) == null) {
                throw new RubyScriptException("no GEM_PATH set");
            }
            return new File(System.getenv(GEM_PATH), "gems");
        }
        return new File(this.gemPath, "gems");
    }

    @Override
    public File binScriptFile(String script) throws RubyScriptException {
        return new File(this.binDirectory(), script);
    }

    public String binScript(String script) throws RubyScriptException {
        return this.binScriptFile(script).getAbsolutePath();
    }
}

