/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import de.saumya.mojo.ruby.GemException;
import de.saumya.mojo.ruby.GemifyManager;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=GemifyManager.class)
public class DefaultGemifyManager
implements GemifyManager {
    @Requirement
    RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    ArtifactHandlerManager artifactHandlerManager;

    @Override
    public ArtifactRepository defaultGemArtifactRepositoryForVersion(String artifactVersion) {
        String preRelease = artifactVersion != null && artifactVersion.matches(".*[a-z][A-Z].*") ? "pre" : "";
        return new MavenArtifactRepository("rubygems-" + preRelease + "releases", "http://gems.saumya.de/" + preRelease + "releases", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
    }

    @Override
    public void addDefaultGemRepositoryForVersion(String artifactVersion, List<ArtifactRepository> repos) {
        ArtifactRepository repo = this.defaultGemArtifactRepositoryForVersion(artifactVersion);
        for (ArtifactRepository ar : repos) {
            if (!ar.getUrl().equals(repo.getUrl())) continue;
            return;
        }
        repos.add(repo);
    }

    @Override
    public Artifact createGemArtifact(String artifactId, String version) throws GemException {
        return this.createArtifact("rubygems", artifactId, version, "gem", "runtime");
    }

    @Override
    public Artifact createArtifact(String gemName, String version, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        return this.createArtifact(this.createArtifactFromGemname(gemName, version), localRepository, remoteRepositories);
    }

    @Override
    public Artifact createArtifact(String groupId, String artifactId, String version, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        return this.createArtifact(this.createArtifact(groupId, artifactId, version, "jar", "test"), localRepository, remoteRepositories);
    }

    @Override
    public Artifact createArtifact(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        if (artifact.getVersion() == null) {
            List<String> versions = this.availableVersions(artifact, localRepository, remoteRepositories);
            artifact.setVersionRange(null);
            artifact.setVersion(versions.get(versions.size() - 1));
        }
        return artifact;
    }

    @Override
    public List<String> availableVersions(String gemName, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        Artifact artifact = this.createArtifactFromGemname(gemName, null);
        return this.availableVersions(artifact, localRepository, remoteRepositories);
    }

    @Override
    public List<String> availableVersions(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws GemException {
        DefaultMetadataResolutionRequest request = new DefaultMetadataResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(request.getArtifact());
        try {
            this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, (RepositoryRequest)request);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new GemException("error updateding versions of artifact: " + artifact, (Exception)((Object)e));
        }
        List versions = metadata.getMetadata().getVersioning().getVersions();
        return versions;
    }

    Artifact createArtifactFromGemname(String gemName, String version) throws GemException {
        int index = gemName.lastIndexOf(".");
        String groupId = gemName.substring(0, index);
        String artifactId = gemName.substring(index + 1);
        return this.createArtifact(groupId, artifactId, version, "jar", "test");
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String type, String scope) throws GemException {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        DefaultArtifact artifact = null;
        try {
            artifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersionSpec((String)(version == null ? "[0.0.0,)" : version)), scope, type, null, handler, false);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new GemException("error parsing the version: " + version, (Exception)((Object)e));
        }
        return artifact;
    }
}

