/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby;

import de.saumya.mojo.ruby.AbstractLauncher;
import de.saumya.mojo.ruby.AntLogAdapter;
import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.RubyScriptException;
import de.saumya.mojo.ruby.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntLauncher
extends AbstractLauncher {
    private static final String MAVEN_CLASSPATH = "maven.classpath";
    private final Logger logger;
    private final ScriptFactory factory;
    private final Project project;

    AntLauncher(Logger logger, ScriptFactory factory) {
        this.logger = logger;
        this.factory = factory;
        this.project = this.createAntProject();
    }

    @Override
    protected void doExecute(File launchDirectory, List<String> args, File outputFile) {
        Java java = new Java();
        java.setProject(this.project);
        java.setClassname("org.jruby.Main");
        java.setFailonerror(true);
        java.setFork(true);
        java.setDir(launchDirectory);
        for (Map.Entry<String, String> entry : this.factory.env.entrySet()) {
            Environment.Variable v = new Environment.Variable();
            v.setKey(entry.getKey());
            v.setValue(entry.getValue());
            java.addEnv(v);
        }
        this.logger.debug("java classpath  : " + this.project.getReference(MAVEN_CLASSPATH));
        if (this.factory.env.size() > 0) {
            this.logger.info("environment     :");
            for (Map.Entry entry : this.factory.env.entrySet()) {
                this.logger.info("\t\t" + (String)entry.getKey() + " => " + (String)entry.getValue());
            }
        }
        for (String string : args) {
            java.createArg().setValue(string);
        }
        java.createJvmarg().setValue("-cp");
        java.createJvmarg().setPath((Path)this.project.getReference(MAVEN_CLASSPATH));
        java.createJvmarg().setValue("-client");
        java.createJvmarg().setValue("-Xbootclasspath/a:" + this.factory.jrubyJar.getAbsolutePath());
        if (outputFile != null) {
            java.setOutput(outputFile);
        }
        java.execute();
    }

    private Project createAntProject() {
        Project project = new Project();
        Path classPath = new Path(project);
        for (String path : this.factory.classpathElements) {
            if (path.contains("jruby-complete")) continue;
            classPath.add(new Path(project, path));
        }
        project.addReference(MAVEN_CLASSPATH, (Object)classPath);
        project.addBuildListener((BuildListener)new AntLogAdapter(this.logger));
        return project;
    }

    @Override
    public void execute(List<String> args) throws RubyScriptException, IOException {
        this.doExecute(null, args, null);
    }

    @Override
    public void execute(List<String> args, File outputFile) throws RubyScriptException, IOException {
        this.doExecute(null, args, outputFile);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args) throws RubyScriptException, IOException {
        this.doExecute(launchDirectory, args, null);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args, File outputFile) throws RubyScriptException, IOException {
        this.doExecute(launchDirectory, args, outputFile);
    }

    @Override
    public void executeScript(String script, List<String> args) throws RubyScriptException, IOException {
        this.executeScript(script, args, null);
    }

    @Override
    public void executeScript(String script, List<String> args, File outputFile) throws RubyScriptException, IOException {
        this.executeScript(null, script, args, outputFile);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args) throws RubyScriptException, IOException {
        this.executeScript(launchDirectory, script, args, null);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args, File outputFile) throws RubyScriptException, IOException {
        args.add(0, "-e");
        args.add(1, script);
        args.add(2, "--");
        this.doExecute(launchDirectory, args, outputFile);
    }
}

