/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo;

import de.saumya.mojo.Launcher;
import de.saumya.mojo.RubyScriptException;
import de.saumya.mojo.ScriptUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedLauncher
implements Launcher {
    private static final Class<?>[] No_ARG_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final ClassRealm classRealm;
    private final Map<String, String> env;

    EmbeddedLauncher(boolean verbose, List<String> classpathElements, Map<String, String> env, File jrubyJarFile, ClassRealm classRealm) throws RubyScriptException {
        this.env = env;
        this.classRealm = classRealm;
    }

    private void do_execute(File launchDirectory, File outputFile, List<String> args) throws RubyScriptException, IOException {
        String currentDir;
        if (launchDirectory != null) {
            currentDir = System.getProperty("user.dir");
            System.setProperty("user.dir", launchDirectory.getAbsolutePath());
        } else {
            currentDir = null;
        }
        PrintStream output = System.out;
        try {
            int status;
            if (outputFile != null) {
                PrintStream writer = new PrintStream(outputFile);
                System.setOut(writer);
                System.err.println("output file: " + outputFile);
            }
            System.err.println("args: " + args);
            Thread.currentThread().setContextClassLoader(this.classRealm.getClassLoader());
            Class clazz = this.classRealm.loadClass("org.jruby.Main");
            Object main = clazz.newInstance();
            Method m = clazz.getMethod("run", String[].class);
            long start = System.currentTimeMillis();
            Object result = m.invoke(main, new Object[]{args.toArray(new String[args.size()])});
            long end = System.currentTimeMillis();
            System.err.println("time " + (end - start));
            if (result instanceof Integer) {
                status = (Integer)result;
            } else {
                Method statusMethod = result.getClass().getMethod("getStatus", No_ARG_TYPES);
                status = (Integer)statusMethod.invoke(result, NO_ARGS);
            }
            if (status != 0) {
                throw new RubyScriptException("some error in script " + args + ": " + status);
            }
        }
        catch (InstantiationException e) {
            throw new RubyScriptException(e);
        }
        catch (IllegalAccessException e) {
            throw new RubyScriptException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RubyScriptException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RubyScriptException(e);
        }
        catch (InvocationTargetException e) {
            throw new RubyScriptException(e);
        }
        finally {
            System.setOut(output);
            if (currentDir != null) {
                System.setProperty("user.dir", currentDir);
            }
        }
    }

    @Override
    public void execute(String ... args) throws RubyScriptException, IOException {
        this.do_execute(null, null, new ArrayList<String>(Arrays.asList(args)));
    }

    @Override
    public void execute(File outputFile, String ... args) throws RubyScriptException, IOException {
        this.do_execute(null, outputFile, new ArrayList<String>(Arrays.asList(args)));
    }

    @Override
    public void executeScript(File launchDirectory, String scriptName, File outputFile, String ... args) throws RubyScriptException, IOException {
        StringBuilder script = new StringBuilder();
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            script.append("ENV['").append(entry.getKey()).append("']='").append(entry.getValue()).append("';");
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("-e");
        script.append("ARGV.clear;ARGV.<<([");
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                script.append(",");
            } else {
                first = false;
            }
            script.append("'").append(arg).append("'");
        }
        script.append("]).flatten!;load('").append(this.scriptUri(scriptName)).append("');");
        list.add(script.toString());
        this.do_execute(launchDirectory, outputFile, list);
    }

    @Override
    public void executeScript(String scriptName, String ... args) throws RubyScriptException, IOException {
        this.executeScript(scriptName, (File)null, args);
    }

    private String scriptUri(String scriptName) throws IOException {
        File scriptPath = new File(scriptName);
        if (scriptPath.exists()) {
            return scriptPath.getAbsolutePath();
        }
        URL url = ScriptUtils.getScript(scriptName);
        if (url.getProtocol().equals("file")) {
            return url.getPath();
        }
        return url.toString();
    }

    @Override
    public void executeIn(File launchDirectory, File outputFile, String ... args) throws RubyScriptException, IOException {
        this.do_execute(launchDirectory, outputFile, new ArrayList<String>(Arrays.asList(args)));
    }

    @Override
    public void executeIn(File launchDirectory, String ... args) throws RubyScriptException, IOException {
        this.do_execute(launchDirectory, null, new ArrayList<String>(Arrays.asList(args)));
    }

    @Override
    public void executeScript(String scriptName, File outputFile, String ... args) throws RubyScriptException, IOException {
        this.executeScript(null, scriptName, outputFile, args);
    }

    @Override
    public void executeScript(File launchDirectory, String scriptName, String ... args) throws RubyScriptException, IOException {
        this.executeScript(launchDirectory, scriptName, (File)null, args);
    }
}

