/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.jruby.JRubyVersion;
import de.saumya.mojo.rspec.RSpecMavenTestScriptFactory;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.tests.AbstractTestMojo;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class RSpecMojo
extends AbstractTestMojo {
    private final String rspecArgs;
    protected String specSourceDirectory;
    protected boolean skipSpecs;
    private String reportName;
    private File outputfile;
    private File specsDir;

    public RSpecMojo() {
        this.rspecArgs = null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipSpecs) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        File file = this.specsDir = this.specSourceDirectory.startsWith(this.launchDirectory().getAbsolutePath()) ? new File(this.specSourceDirectory) : new File(this.launchDirectory(), this.specSourceDirectory);
        if (!this.specsDir.isDirectory()) {
            this.getLog().info((CharSequence)("given " + this.specSourceDirectory + " does not exists - skipping RSpec test'"));
            return;
        }
        this.outputfile = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""), this.reportName);
        if (this.outputfile.exists()) {
            this.outputfile.delete();
        }
        super.execute();
    }

    protected JRubyRun.Result runIt(ScriptFactory factory, JRubyVersion.Mode mode, JRubyVersion version, TestScriptFactory scriptFactory) throws IOException, ScriptException, MojoExecutionException {
        scriptFactory.setOutputDir(this.outputfile.getParentFile());
        scriptFactory.setReportPath(this.outputfile);
        scriptFactory.setSourceDir(this.specsDir);
        Script script = factory.newScript(scriptFactory.getCoreScript());
        if (this.rspecArgs != null) {
            script.addArgs(this.rspecArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        Exception error = null;
        try {
            script.executeIn(this.launchDirectory());
        }
        catch (Exception e) {
            error = e;
            this.getLog().debug((CharSequence)"exception in running specs", (Throwable)e);
        }
        String reportPath = this.outputfile.getAbsolutePath();
        File reportFile = version != null && this.modes != null ? new File(reportPath.replace(".html", "-" + version + mode.name() + ".html")) : (this.versions == null || this.versions.isEmpty() || version == null ? new File(reportPath) : new File(reportPath.replace(".html", "-" + version + ".html")));
        new File(reportPath).renameTo(reportFile);
        JRubyRun.Result result = new JRubyRun.Result();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(reportFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("failure") || !line.contains("example")) continue;
                result.message = line.replaceFirst("\";</.*>", "").replaceFirst("<.*\"", "");
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to read test report file: " + reportFile);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        if (result.message == null) {
            if (reportFile.length() == 0L) {
                if (error == null) {
                    result.success = true;
                } else {
                    result.message = "An error occurred";
                    result.success = false;
                }
            } else {
                result.message = "An unknown error occurred";
                result.success = false;
            }
        } else {
            String filename = "TEST-rspec" + (mode == null ? "" : (version == null ? "" : "-" + version + mode.flag)) + ".xml";
            System.out.println(filename);
            File xmlReport = new File(this.testReportDirectory, filename);
            new File(this.testReportDirectory, "TEST-rspec.xml").renameTo(xmlReport);
            if (this.summaryReport != null) {
                FileUtils.copyFile((File)xmlReport, (File)this.summaryReport);
            }
            result.success = result.message.contains("0 failures");
        }
        return result;
    }

    protected TestScriptFactory newTestScriptFactory() {
        return new RSpecMavenTestScriptFactory();
    }
}

