/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.rspec.RSpecMavenTestScriptFactory;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.tests.AbstractTestMojo;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class RSpecMojo
extends AbstractTestMojo {
    private final String rspecArgs;
    protected String specSourceDirectory;
    protected boolean skipSpecs;
    private String reportName;
    private File outputfile;

    public RSpecMojo() {
        this.rspecArgs = null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipSpecs) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        this.outputfile = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""), this.reportName);
        if (this.outputfile.exists()) {
            this.outputfile.delete();
        }
        super.execute();
    }

    protected JRubyRun.Result runIt(ScriptFactory factory, JRubyRun.Mode mode, String version, TestScriptFactory scriptFactory) throws IOException, ScriptException, MojoExecutionException {
        scriptFactory.setOutputDir(this.outputfile.getParentFile());
        scriptFactory.setReportPath(this.outputfile);
        if (this.specSourceDirectory.startsWith(this.launchDirectory().getAbsolutePath())) {
            scriptFactory.setSourceDir(new File(this.specSourceDirectory));
        } else {
            scriptFactory.setSourceDir(new File(this.launchDirectory(), this.specSourceDirectory));
        }
        Script script = factory.newScript(scriptFactory.getCoreScript());
        if (this.rspecArgs != null) {
            script.addArgs(this.rspecArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        try {
            script.executeIn(this.launchDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"exception in running specs", (Throwable)e);
        }
        String reportPath = this.outputfile.getAbsolutePath();
        File reportFile = mode != JRubyRun.Mode.DEFAULT ? new File(reportPath.replace(".html", "-" + version + mode.name() + ".html")) : (this.jrubyVersion.equals(version) ? new File(reportPath) : new File(reportPath.replace(".html", "-" + version + ".html")));
        new File(reportPath).renameTo(reportFile);
        JRubyRun.Result result = new JRubyRun.Result();
        FileReader in = null;
        try {
            in = new FileReader(reportFile);
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("failure") || !line.contains("example")) continue;
                result.message = line.replaceFirst("\";</.*>", "").replaceFirst("<.*\"", "");
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read test report file: " + reportFile);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        if (result.message == null) {
            if (reportFile.length() == 0L) {
                result.success = true;
            } else {
                result.message = "An unknown error occurred";
                result.success = false;
            }
        } else {
            String filename = "TEST-rspec" + (mode.flag == null ? "" : "-" + version + mode.flag) + ".xml";
            File xmlReport = new File(this.testReportDirectory, filename);
            new File(this.testReportDirectory, "TEST-rspec.xml").renameTo(xmlReport);
            if (this.summaryReport != null) {
                FileUtils.copyFile((File)xmlReport, (File)this.summaryReport);
            }
            result.success = result.message.contains("0 failures");
        }
        return result;
    }

    protected TestScriptFactory newTestScriptFactory(JRubyRun.Mode mode) {
        return new RSpecMavenTestScriptFactory();
    }
}

