/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.rspec.RSpec1ScriptFactory;
import de.saumya.mojo.rspec.RSpec2ScriptFactory;
import de.saumya.mojo.rspec.ScriptFactory;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.runit.AbstractTestMojo;
import de.saumya.mojo.runit.JRubyRun;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSpecMojo
extends AbstractTestMojo {
    protected File basedir;
    protected List<String> classpathElements;
    protected boolean skipSpecs = false;
    protected String specSourceDirectory;
    protected File outputDirectory;
    protected String reportName;
    protected Properties systemProperties;
    private String rspecVersion;
    private RepositorySystemSession repoSession;
    private ScriptFactory rspecScriptFactory;
    private String reportPath;

    private File specSourceDirectory() {
        return new File(this.launchDirectory(), this.specSourceDirectory);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests || this.skipSpecs) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        super.execute();
    }

    @Override
    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        File specSourceDirectory = this.specSourceDirectory();
        if (!specSourceDirectory.exists() && this.args == null) {
            this.getLog().info((CharSequence)("Skipping RSpec tests since " + specSourceDirectory + " is missing"));
            return;
        }
        this.getLog().info((CharSequence)("Running RSpec tests from " + specSourceDirectory));
        if (this.project.getBasedir() == null) {
            this.rspecVersion = this.gemsInstaller.installGem("rspec", this.rspecVersion, this.repoSession, this.localRepository).getVersion();
        }
        this.reportPath = new File(this.outputDirectory, this.reportName).getAbsolutePath();
        this.initScriptFactory(this.getRSpecScriptFactory(), this.reportPath);
        try {
            this.rspecScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .rb", (Throwable)e);
        }
        super.executeWithGems();
    }

    @Override
    protected JRubyRun.Result runIt(de.saumya.mojo.ruby.script.ScriptFactory factory, JRubyRun.Mode mode, String version) throws IOException, ScriptException, MojoExecutionException {
        Script script = factory.newScript(this.rspecScriptFactory.getScriptFile());
        script.addArgs(this.args);
        script.executeIn(this.launchDirectory());
        File reportFile = mode != JRubyRun.Mode.DEFAULT ? new File(this.reportPath.replace(".html", "-" + version + mode.name() + ".html")) : (this.jrubyVersion.equals(version) ? new File(this.reportPath) : new File(this.reportPath.replace(".html", "-" + version + ".html")));
        new File(this.reportPath).renameTo(reportFile);
        JRubyRun.Result result = new JRubyRun.Result();
        FileReader in = null;
        try {
            in = new FileReader(reportFile);
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("failure") || !line.contains("example")) continue;
                result.message = line.replaceFirst("\";</.*>", "").replaceFirst("<.*\"", "");
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read test report file: " + reportFile);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        if (result.message == null) {
            result.message = "An unknown error occurred";
            result.success = false;
        } else {
            result.success = result.message.contains("0 failures");
        }
        return result;
    }

    private void initScriptFactory(ScriptFactory factory, String reportPath) {
        factory.setBaseDir(this.basedir.getAbsolutePath());
        factory.setSummaryReport(this.summaryReport);
        factory.setOutputDir(this.outputDirectory);
        factory.setReportPath(reportPath);
        factory.setSourceDir(this.specSourceDirectory().getAbsolutePath());
        factory.setClasspathElements(this.classpathElements);
        factory.setGemHome(this.gemHome);
        factory.setGemPaths(new File[]{this.gemPath, new File(this.gemPath.getParentFile(), this.gemPath.getName() + "-rspec-maven-plugin")});
        Properties props = this.systemProperties;
        if (props == null) {
            props = new Properties();
        }
        factory.setSystemProperties(props);
    }

    private ScriptFactory scriptFactory4Version(String version) {
        if (version.startsWith("1.")) {
            return new RSpec1ScriptFactory();
        }
        if (version.startsWith("2.")) {
            return new RSpec2ScriptFactory();
        }
        return null;
    }

    private ScriptFactory getRSpecScriptFactory() throws MojoExecutionException {
        if (this.rspecScriptFactory != null) {
            return this.rspecScriptFactory;
        }
        this.rspecScriptFactory = this.getRSpecScriptFactory(this.project.getDependencyArtifacts());
        if (this.rspecScriptFactory == null) {
            this.rspecScriptFactory = this.getRSpecScriptFactory(this.plugin.getArtifacts());
        }
        if (this.rspecScriptFactory == null) {
            if (this.rspecVersion == null && this.project.getBasedir() != null) {
                throw new MojoExecutionException("please add a gem dependency for rspec to your POM");
            }
            this.rspecScriptFactory = this.scriptFactory4Version(this.rspecVersion);
        }
        if (this.rspecScriptFactory == null) {
            throw new MojoExecutionException("Unable to determine version of RSpec");
        }
        return this.rspecScriptFactory;
    }

    private ScriptFactory getRSpecScriptFactory(Collection<Artifact> dependencyArtifacts) {
        for (Artifact each : dependencyArtifacts) {
            if (!each.getGroupId().equals("rubygems") || !each.getArtifactId().equals("rspec")) continue;
            return this.scriptFactory4Version(each.getVersion());
        }
        return null;
    }
}

