/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.rspec.RSpec1ScriptFactory;
import de.saumya.mojo.rspec.RSpec2ScriptFactory;
import de.saumya.mojo.rspec.ScriptFactory;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.sonatype.aether.RepositorySystemSession;

public class RSpecMojo
extends AbstractGemMojo {
    protected File basedir;
    protected List<String> classpathElements;
    protected boolean skipTests;
    protected boolean skipSpecs = false;
    protected String specSourceDirectory;
    protected String outputDirectory;
    protected String reportName;
    protected Properties systemProperties;
    private final String rspecVersion = "1.3.1";
    private RepositorySystemSession repoSession;
    private ScriptFactory rspecScriptFactory;

    private File specSourceDirectory() {
        return new File(this.launchDirectory(), this.specSourceDirectory);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests || this.skipSpecs) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        super.execute();
    }

    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        File specSourceDirectory;
        if (this.project.getBasedir() == null) {
            this.gemsInstaller.installGem("rspec", this.rspecVersion, this.repoSession, this.localRepository);
        }
        if (!(specSourceDirectory = this.specSourceDirectory()).exists()) {
            this.getLog().info((CharSequence)("Skipping RSpec tests since " + specSourceDirectory + " is missing"));
            return;
        }
        this.getLog().info((CharSequence)("Running RSpec tests from " + specSourceDirectory));
        String reportPath = new File(this.outputDirectory, this.reportName).getAbsolutePath();
        this.initScriptFactory(this.getRSpecScriptFactory(), reportPath);
        try {
            this.rspecScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .rb", (Throwable)e);
        }
        this.factory.newScript(this.rspecScriptFactory.getScriptFile()).executeIn(this.launchDirectory());
        File reportFile = new File(reportPath);
        FileReader in = null;
        try {
            in = new FileReader(reportFile);
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("0 failures")) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read test report file: " + reportFile);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        throw new MojoExecutionException("There were test failures");
    }

    private void initScriptFactory(ScriptFactory factory, String reportPath) {
        factory.setBaseDir(this.basedir.getAbsolutePath());
        factory.setOutputDir(new File(this.outputDirectory));
        factory.setReportPath(reportPath);
        factory.setSourceDir(this.specSourceDirectory().getAbsolutePath());
        factory.setClasspathElements(this.classpathElements);
        factory.setGemHome(this.gemHome);
        factory.setGemPath(this.gemPath);
        Properties props = this.systemProperties;
        if (props == null) {
            props = new Properties();
        }
        factory.setSystemProperties(props);
    }

    private ScriptFactory scriptFactory4Version(String version) {
        if (version.startsWith("1.")) {
            return new RSpec1ScriptFactory();
        }
        if (version.startsWith("2.")) {
            return new RSpec2ScriptFactory();
        }
        return null;
    }

    private ScriptFactory getRSpecScriptFactory() throws MojoExecutionException {
        if (this.rspecScriptFactory != null) {
            return this.rspecScriptFactory;
        }
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        for (Artifact each : dependencyArtifacts) {
            if (!each.getGroupId().equals("rubygems") || !each.getArtifactId().equals("rspec") || !each.getScope().equals("test")) continue;
            this.rspecScriptFactory = this.scriptFactory4Version(each.getVersion());
            break;
        }
        if (this.rspecScriptFactory == null && this.project.getBasedir() == null) {
            this.rspecScriptFactory = this.scriptFactory4Version("1.3.1");
        }
        if (this.rspecScriptFactory == null) {
            throw new MojoExecutionException("Unable to determine version of RSpec");
        }
        return this.rspecScriptFactory;
    }
}

