/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.rspec.AbstractScriptFactory;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class AbstractRSpecScriptFactory
extends AbstractScriptFactory {
    public String getScript() throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPrologScript());
        builder.append(this.getRubygemsSetupScript());
        builder.append(this.getSystemPropertiesScript());
        builder.append(this.getPluginClasspathScript());
        builder.append(this.getTestClasspathSetupScript());
        builder.append(this.getConstantsConfigScript());
        builder.append(this.getRSpecRunnerScript());
        builder.append(this.getResultsScript());
        return builder.toString();
    }

    private String getSystemPropertiesScript() {
        if (this.systemProperties.keySet().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("# Set up system-properties for running outside of maven\n");
        builder.append("\n");
        for (Object propName : this.systemProperties.keySet()) {
            String propValue = this.systemProperties.getProperty(propName.toString());
            builder.append("Java::java.lang::System.setProperty( %q(" + propName.toString() + "), %q(" + propValue + ") )\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    private String getConstantsConfigScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("# Constants used for configuration and execution\n");
        builder.append("\n");
        builder.append("BASE_DIR=%q(" + this.sanitize(this.baseDir) + ")\n");
        builder.append("SPEC_DIR=%q(" + this.sanitize(this.sourceDir) + ")\n");
        builder.append("REPORT_PATH=%q(" + this.sanitize(this.reportPath) + ")\n");
        builder.append("\n");
        builder.append("$: << File.join( BASE_DIR, 'lib' )\n");
        builder.append("$: << SPEC_DIR\n");
        builder.append("\n");
        return builder.toString();
    }

    protected abstract String getRSpecRunnerScript();

    private String getResultsScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("# A little magic to report back to maven\n");
        builder.append("\n");
        builder.append("if File.new(REPORT_PATH, 'r').read =~ /, 0 failures/ \n");
        builder.append("  if ( $0 == __FILE__ )\n");
        builder.append("    exit 0\n");
        builder.append("  end\n");
        builder.append("  false\n");
        builder.append("else\n");
        builder.append("  if ( $0 == __FILE__ )\n");
        builder.append("    exit 1\n");
        builder.append("  end\n");
        builder.append("  true\n");
        builder.append("end\n");
        builder.append("\n");
        return builder.toString();
    }

    private String getPrologScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("require %(java)\n");
        builder.append("\n");
        return builder.toString();
    }

    private String getRubygemsSetupScript() {
        if (this.gemHome == null && this.gemPath == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("# Set up GEM_HOME and GEM_PATH for running outside of maven\n");
        builder.append("\n");
        if (this.gemHome != null) {
            builder.append("ENV['GEM_HOME']='" + this.gemHome + "'\n");
        }
        if (this.gemPath != null) {
            builder.append("ENV['GEM_PATH']='" + this.gemPath + "'\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    private String getTestClasspathSetupScript() {
        StringBuilder builder = new StringBuilder();
        builder.append("# Set up the classpath for running outside of maven\n");
        builder.append("\n");
        builder.append("def add_classpath_element(element)\n");
        builder.append("  JRuby.runtime.jruby_class_loader.addURL( Java::java.net::URL.new( element ) )\n");
        builder.append("end\n");
        builder.append("\n");
        for (String path : this.classpathElements) {
            if (!path.endsWith("jar") && !path.endsWith("/")) {
                path = path + "/";
            }
            builder.append("add_classpath_element(%Q( file://" + this.sanitize(path) + " ))\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    private String sanitize(String path) {
        String sanitized = path.replaceAll("\\\\", "/");
        if (sanitized.matches("^[a-z]:.*")) {
            sanitized = sanitized.substring(0, 1).toUpperCase() + sanitized.substring(1);
        }
        return sanitized;
    }

    private String getPluginClasspathScript() {
        int bangLoc;
        String pathToClass = this.getClass().getName().replaceAll("\\.", "/") + ".class";
        URL here = this.getClass().getClassLoader().getResource(pathToClass);
        String herePath = here.getPath();
        if (herePath.startsWith("file:") && (bangLoc = (herePath = herePath.substring(5)).indexOf("!")) > 0) {
            herePath = herePath.substring(0, bangLoc);
        }
        if (herePath.endsWith(".jar")) {
            return "require %q(" + herePath + ")\n";
        }
        return "$: << %q(" + herePath + ")\n";
    }

    protected String getScriptName() {
        return "rspec-runner.rb";
    }
}

