/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rspec;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.rspec.RSpecScriptFactory;
import de.saumya.mojo.rspec.ScriptFactory;
import de.saumya.mojo.rspec.ShellScriptFactory;
import de.saumya.mojo.ruby.RubyScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RSpecMojo
extends AbstractGemMojo {
    protected File basedir;
    protected List<String> classpathElements;
    protected boolean skipTests;
    protected String specSourceDirectory;
    protected String outputDirectory;
    protected String reportName;
    protected Properties systemProperties;
    private RSpecScriptFactory rspecScriptFactory = new RSpecScriptFactory();
    private ShellScriptFactory shellScriptFactory = new ShellScriptFactory();

    private File specSourceDirectory() {
        return new File(this.launchDirectory(), this.specSourceDirectory);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        super.execute();
    }

    public void executeWithGems() throws MojoExecutionException, RubyScriptException, IOException {
        File specSourceDirectory = this.specSourceDirectory();
        if (!specSourceDirectory.exists()) {
            this.getLog().info((CharSequence)("Skipping RSpec tests since " + specSourceDirectory + " is missing"));
            return;
        }
        this.getLog().info((CharSequence)("Running RSpec tests from " + specSourceDirectory));
        String reportPath = new File(this.outputDirectory, this.reportName).getAbsolutePath();
        this.initScriptFactory(this.rspecScriptFactory, reportPath);
        this.initScriptFactory(this.shellScriptFactory, reportPath);
        try {
            this.rspecScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .rb", (Throwable)e);
        }
        try {
            this.shellScriptFactory.emit();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"error emitting .sh", (Throwable)e);
        }
        this.factory.newScript(this.rspecScriptFactory.getScriptFile()).executeIn(this.launchDirectory());
        File reportFile = new File(reportPath);
        FileReader in = null;
        try {
            in = new FileReader(reportFile);
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("0 failures")) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read test report file: " + reportFile);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        throw new MojoExecutionException("There were test failures");
    }

    private void initScriptFactory(ScriptFactory factory, String reportPath) {
        factory.setBaseDir(this.basedir.getAbsolutePath());
        factory.setClasspathElements(this.classpathElements);
        factory.setOutputDir(new File(this.outputDirectory));
        factory.setReportPath(reportPath);
        factory.setSourceDir(this.specSourceDirectory().getAbsolutePath());
        factory.setGemHome(this.gemHome);
        factory.setGemPath(this.gemPath);
        Properties props = this.systemProperties;
        if (props == null) {
            props = new Properties();
        }
        factory.setSystemProperties(props);
    }
}

