/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rake;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "de.saumya.mojo:rake-maven-plugin:1.0.6", 0);
        this.append(sb, "", 0);
        this.append(sb, "Rake Maven Mojo", 0);
        this.append(sb, "shared dependencies and plugins for the mojos", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rake:help", 0);
            this.append(sb, "Display help information on rake-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rake:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rails".equals(this.goal)) {
            this.append(sb, "rake:rails", 0);
            this.append(sb, "goal to run rails rake with the given arguments.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments\nCommand line -Dargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.\nCommand line -Dgem.binDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "env", 2);
                this.append(sb, "either development or test or production or whatever else is possible with your config", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby. default will be ignored when gemUseSystem is true.\nCommand line -Dgem.home=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHomes", 2);
                this.append(sb, "map different install locations for rubygems (GEM_HOME) to a directory. examples are the different scopes like provided and test as well when installed inside a plugin declaration, where the key is the artifactId of the plugin.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby. default will be ignored when gemUseSystem is true.\nCommand line -Dgem.path=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemUseSystem (Default: false)", 2);
                this.append(sb, "use system gems instead of setting up GemPath/GemHome inside the build directory and ignores any set gemHome and gemPath. you need to have both GEM_HOME and GEM_PATH environment variable set to make it work.\nCommand line -Dgem.useSystem=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeGemsInResources", 2);
                this.append(sb, "EXPERIMENTAL this gives the scope of the gems which shall be included to resources. flag whether to include all gems to resources, i.e. to classpath or not. the difference to the includeRubygemsInResources is that it does not depend on rubygems during runtime since the required_path of the gems gets added to resources. note that it expect the required_path of the gem to be lib which is the default BUT that is not true for all gems. in this sense this feature is incomplete and might not work for you !!! IMPORTANT: it only adds the gems with provided scope since they are packed with the jar and then the pom.xml will not have them (since they are marked 'provided') as transitive dependencies. this feature can be helpful in situations where the classloader does not work for rubygems due to rubygems uses file system globs to find the gems and this only works if the classloader reveals the jar url of its jars (i.e. URLClassLoader). for example OSGi classloader can not work with rubygems !!\nCommand line -Dgem.includeGemsInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeLibDirectoryInResources (Default: false)", 2);
                this.append(sb, "\nCommand line -Dgem.includeLibDirectoryInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "flag whether to include open-ssl gem or not\nCommand line -Dgem.includeOpenSSL=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeRubygemsInResources (Default: false)", 2);
                this.append(sb, "flag whether to include all gems to resources, i.e. to classpath or not\nCommand line -Dgem.includeRubygemsInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeRubygemsInTestResources (Default: true)", 2);
                this.append(sb, "flag whether to include all gems to test-resources, i.e. to test-classpath or not\nCommand line -Dgem.includeRubygemsInTestResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "flag whether to install rdocs of the used gems or not\nCommand line -Dgem.installRDoc=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "flag whether to install ri of the used gems or not\nCommand line -Dgem.installRDoc=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command, like '--1.9'\nCommand line -Djruby.switches=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${project.basedir})", 2);
                this.append(sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: lib)", 2);
                this.append(sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "plugin", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakeArgs (Default: ${rake.args})", 2);
                this.append(sb, "arguments for the generate command", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubySourceDirectory (Default: src/main/ruby)", 2);
                this.append(sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "supportNative (Default: false)", 2);
                this.append(sb, "flag to indicate to setup jruby's native support for C-extensions\nCommand line -Dgem.supportNative=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "task (Default: ${task})", 2);
                this.append(sb, "the path to the application to be generated", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rake".equals(this.goal)) {
            this.append(sb, "rake:rake", 0);
            this.append(sb, "maven wrapper around the rake command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments\nCommand line -Dargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.\nCommand line -Dgem.binDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "env", 2);
                this.append(sb, "environment values passed on to the jruby process. needs jrubyFork true.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby. default will be ignored when gemUseSystem is true.\nCommand line -Dgem.home=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHomes", 2);
                this.append(sb, "map different install locations for rubygems (GEM_HOME) to a directory. examples are the different scopes like provided and test as well when installed inside a plugin declaration, where the key is the artifactId of the plugin.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby. default will be ignored when gemUseSystem is true.\nCommand line -Dgem.path=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemUseSystem (Default: false)", 2);
                this.append(sb, "use system gems instead of setting up GemPath/GemHome inside the build directory and ignores any set gemHome and gemPath. you need to have both GEM_HOME and GEM_PATH environment variable set to make it work.\nCommand line -Dgem.useSystem=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeGemsInResources", 2);
                this.append(sb, "EXPERIMENTAL this gives the scope of the gems which shall be included to resources. flag whether to include all gems to resources, i.e. to classpath or not. the difference to the includeRubygemsInResources is that it does not depend on rubygems during runtime since the required_path of the gems gets added to resources. note that it expect the required_path of the gem to be lib which is the default BUT that is not true for all gems. in this sense this feature is incomplete and might not work for you !!! IMPORTANT: it only adds the gems with provided scope since they are packed with the jar and then the pom.xml will not have them (since they are marked 'provided') as transitive dependencies. this feature can be helpful in situations where the classloader does not work for rubygems due to rubygems uses file system globs to find the gems and this only works if the classloader reveals the jar url of its jars (i.e. URLClassLoader). for example OSGi classloader can not work with rubygems !!\nCommand line -Dgem.includeGemsInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeLibDirectoryInResources (Default: false)", 2);
                this.append(sb, "\nCommand line -Dgem.includeLibDirectoryInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "flag whether to include open-ssl gem or not\nCommand line -Dgem.includeOpenSSL=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeRubygemsInResources (Default: false)", 2);
                this.append(sb, "flag whether to include all gems to resources, i.e. to classpath or not\nCommand line -Dgem.includeRubygemsInResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeRubygemsInTestResources (Default: true)", 2);
                this.append(sb, "flag whether to include all gems to test-resources, i.e. to test-classpath or not\nCommand line -Dgem.includeRubygemsInTestResources=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "flag whether to install rdocs of the used gems or not\nCommand line -Dgem.installRDoc=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "flag whether to install ri of the used gems or not\nCommand line -Dgem.installRDoc=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.\nCommand line -Djruby.fork=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "jvm arguments for the java command executing jruby\nCommand line -Djruby.jvmargs=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command, like '--1.9'\nCommand line -Djruby.switches=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output\nCommand line -Djruby.verbose=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. it overwrites the jruby version from the dependencies if any. i.e. you can easily switch jruby version from the commandline !\ndefault: 1.7.12\nCommand line -Djruby.version=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${project.basedir})", 2);
                this.append(sb, "the launch directory for the JRuby execution.\nCommand line -Djruby.launchDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDirectory (Default: lib)", 2);
                this.append(sb, "directory with ruby sources - added to ruby loadpath only\nCommand line -Djruby.lib=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "plugin", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakeArgs (Default: ${rake.args})", 2);
                this.append(sb, "arguments for the rake command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakefile (Default: ${rake.file})", 2);
                this.append(sb, "rakefile to be used for the rake command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakeVersion (Default: ${rake.version})", 2);
                this.append(sb, "rake version used when there is no pom. defaults to latest version. DEPRECATED: declare a gem dependency with the desired version instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubySourceDirectory (Default: src/main/ruby)", 2);
                this.append(sb, "directory with ruby sources - added to java classpath and ruby loadpath\nCommand line -Djruby.sourceDirectory=...", 3);
                this.append(sb, "", 0);
                this.append(sb, "supportNative (Default: false)", 2);
                this.append(sb, "flag to indicate to setup jruby's native support for C-extensions\nCommand line -Dgem.supportNative=...", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

