/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby;

import de.saumya.mojo.jruby.MojoLogger;
import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.classworlds.ClassRealm;

public abstract class AbstractJRubyMojo
extends AbstractMojo {
    private static String DEFAULT_JRUBY_VERSION = "1.5.3";
    public static final String GEM_RUBY_COMMAND = "META-INF/jruby.home/bin/gem";
    public static final String IRB_RUBY_COMMAND = "jirb";
    public static final String IRB_SWING_RUBY_COMMAND = "jirb_swing";
    public static final String RAKE_RUBY_COMMAND = "META-INF/jruby.home/bin/rake";
    protected String args;
    protected String jrubyArgs = null;
    protected String jrubyVersion;
    protected boolean jrubyFork;
    protected boolean jrubyVerbose;
    private File launchDirectory;
    @Deprecated
    protected File jrubyGemHome;
    @Deprecated
    protected File jrubyGemPath;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ClassRealm classRealm;
    protected RepositorySystem repositorySystem;
    protected Logger logger;
    protected ScriptFactory factory;

    protected ScriptFactory newScriptFactory() throws MojoExecutionException {
        try {
            ScriptFactory factory = new ScriptFactory(this.logger, this.classRealm, this.resolveJRUBYCompleteArtifact().getFile(), this.project.getTestClasspathElements(), this.jrubyFork);
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logger = new MojoLogger(this.jrubyVerbose, this.getLog());
        this.factory = this.newScriptFactory();
        this.factory.addJavaArgs(this.jrubyArgs);
        if (this.jrubyGemHome != null) {
            this.factory.addEnv("GEM_HOME", this.jrubyGemHome.getAbsolutePath().replaceFirst(".*/[$][{]project.basedir[}]/", ""));
        }
        if (this.jrubyGemPath != null) {
            this.factory.addEnv("GEM_PATH", this.jrubyGemPath.getAbsolutePath().replaceFirst(".*/[$][{]project.basedir[}]/", ""));
        }
        try {
            this.executeJRuby();
        }
        catch (IOException e) {
            throw new MojoExecutionException("error in executing jruby", (Exception)e);
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("error in executing jruby", (Exception)((Object)e));
        }
    }

    protected abstract void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, ScriptException;

    protected File launchDirectory() {
        if (this.launchDirectory == null) {
            this.launchDirectory = this.project.getBasedir();
            if (this.launchDirectory == null || !this.launchDirectory.exists()) {
                this.launchDirectory = new File(System.getProperty("user.dir"));
            }
        }
        return this.launchDirectory;
    }

    private Artifact resolveJRUBYCompleteArtifact(String version) throws DependencyResolutionRequiredException {
        this.getLog().debug((CharSequence)("resolve jruby for verions " + version));
        Artifact artifact = this.repositorySystem.createArtifact("org.jruby", "jruby-complete", version, "jar");
        return this.resolveJRUBYCompleteArtifact(artifact);
    }

    private Artifact resolveJRUBYCompleteArtifact(Artifact artifact) throws DependencyResolutionRequiredException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setLocalRepository(this.localRepository);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        this.repositorySystem.resolve(request);
        if (this.jrubyVerbose) {
            this.getLog().info((CharSequence)("jruby version   : " + artifact.getVersion()));
        }
        this.jrubyVersion = artifact.getVersion();
        return artifact;
    }

    protected Artifact resolveJRUBYCompleteArtifact() throws DependencyResolutionRequiredException, MojoExecutionException {
        if (this.jrubyVersion != null) {
            return this.resolveJRUBYCompleteArtifact(this.jrubyVersion);
        }
        for (Dependency o : this.project.getDependencies()) {
            Dependency artifact = o;
            if (!artifact.getArtifactId().equals("jruby-complete") || artifact.getScope().equals("provided") || artifact.getScope().equals("system")) continue;
            return this.resolveJRUBYCompleteArtifact(this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType()));
        }
        return this.resolveJRUBYCompleteArtifact(DEFAULT_JRUBY_VERSION);
    }
}

