/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rake;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "de.saumya.mojo:rake-maven-plugin:0.21.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Rake Maven Mojo", 0);
        this.append(sb, "shared dependencies and plugins for the mojos", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rake:help", 0);
            this.append(sb, "Display help information on rake-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rake:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rake".equals(this.goal)) {
            this.append(sb, "rake:rake", 0);
            this.append(sb, "maven wrapper around the rake command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceVersion (Default: false)", 2);
                this.append(sb, "allow to overwrite the version by explicitly declaring a dependency in the pom. will not check any dependencies on gemspecs level.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemInitializeArgs (Default: ${gem.initializeArgs})", 2);
                this.append(sb, "arguments for the gem command during base initialization.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyGemHome", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyGemPath", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.2'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakeArgs (Default: ${rake.args})", 2);
                this.append(sb, "arguments for the rake command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakefile (Default: ${rake.file})", 2);
                this.append(sb, "rakefile to be used for the rake command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rakeVersion (Default: 0.8.7)", 2);
                this.append(sb, "rake version used when there is no pom. defaults to 0.8.7", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

