/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gems.GemspecConverter;
import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.GemException;
import de.saumya.mojo.ruby.GemScriptFactory;
import de.saumya.mojo.ruby.GemService;
import de.saumya.mojo.ruby.GemifyManager;
import de.saumya.mojo.ruby.RubyScriptException;
import de.saumya.mojo.ruby.Script;
import de.saumya.mojo.ruby.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGemMojo
extends AbstractJRubyMojo {
    private static Set<Artifact> NO_ARTIFACTS = Collections.emptySet();
    protected boolean includeOpenSSL;
    protected boolean installRDoc;
    protected boolean installRI;
    private boolean forceVersion;
    private boolean update;
    protected File gemHome;
    protected File gemPath;
    protected String gemArgs;
    protected String gemInitializeArgs;
    protected GemifyManager manager;
    protected GemService gemService;

    @Override
    protected ScriptFactory newScriptFactory() throws MojoExecutionException {
        try {
            if (this.jrubyGemHome != null) {
                this.gemHome = this.jrubyGemHome;
            }
            if (this.jrubyGemPath != null) {
                this.gemPath = this.jrubyGemPath;
            }
            GemScriptFactory factory = new GemScriptFactory(this.logger, this.classRealm, this.resolveJRUBYCompleteArtifact().getFile(), this.project.getTestClasspathElements(), this.jrubyFork, this.gemHome, this.gemPath);
            this.gemService = factory;
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (RubyScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    @Override
    protected void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, RubyScriptException {
        if (this.project.getBasedir() == null) {
            this.gemHome = new File(this.gemHome.getAbsolutePath().replace("/${project.basedir}/", "/"));
            this.gemPath = new File(this.gemPath.getAbsolutePath().replace("/${project.basedir}/", "/"));
        }
        this.updateMetadata();
        if (this.project.getArtifacts().size() > 0) {
            this.setupGems(this.project.getArtifacts(), false);
        }
        this.executeWithGems();
    }

    protected void setupGems(Artifact artifact) throws MojoExecutionException, IOException, RubyScriptException {
        this.setupGems(Arrays.asList(artifact), true);
    }

    void updateMetadata() throws MojoExecutionException {
        if (this.update) {
            ArrayList<String> done = new ArrayList<String>();
            for (ArtifactRepository repo : this.project.getRemoteArtifactRepositories()) {
                if (!repo.getId().startsWith("rubygems")) continue;
                URL url = null;
                try {
                    url = new URL(repo.getUrl() + "/update");
                    if (done.contains(url.getHost())) continue;
                    done.add(url.getHost());
                    InputStream in = url.openStream();
                    in.read();
                    in.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("error in sending update url: " + url, (Exception)e);
                }
            }
        }
    }

    void updateLocalMetadata() throws MojoExecutionException {
        if (this.update) {
            try {
                GemspecConverter gemService = new GemspecConverter(this.logger, this.factory);
                ArrayList<String> ids = new ArrayList<String>();
                for (ArtifactRepository repo : this.project.getRemoteArtifactRepositories()) {
                    ids.add(repo.getId());
                }
                gemService.updateMetadata(ids, this.localRepository.getBasedir());
            }
            catch (RubyScriptException e) {
                throw new MojoExecutionException("error in rake script", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO error", (Exception)e);
            }
        }
    }

    private void setupGems(Collection<Artifact> artifacts, boolean resolve) throws MojoExecutionException, IOException, RubyScriptException {
        if (this.includeOpenSSL) {
            try {
                Artifact openssl = this.manager.createGemArtifact("jruby-openssl", "0.7");
                artifacts = new HashSet<Artifact>(artifacts);
                artifacts.add(openssl);
            }
            catch (GemException e) {
                throw new MojoExecutionException("error creating artifact coordinate for jruby-openssl", (Exception)((Object)e));
            }
        }
        File gemsDir = new File(this.gemPath, "gems");
        StringBuilder gems = new StringBuilder();
        LinkedHashMap<String, Artifact> collectedArtifacts = new LinkedHashMap<String, Artifact>();
        for (Artifact artifact : artifacts) {
            if (!artifact.getType().contains("gem") && artifact != this.project.getArtifact()) continue;
            this.collectArtifacts(artifact, collectedArtifacts, resolve);
        }
        collectedArtifacts.remove(this.key(this.project.getArtifact()));
        String extraFlag = null;
        if (this.forceVersion) {
            for (Dependency artifact : this.project.getDependencies()) {
                Artifact a = (Artifact)collectedArtifacts.get(artifact.getGroupId() + ":" + artifact.getArtifactId());
                if (a.getVersion().equals(artifact.getVersion())) continue;
                extraFlag = "--force";
                a.setVersion(artifact.getVersion());
                a.setResolved(false);
                a.setFile(null);
                this.resolve(a);
            }
        }
        for (Artifact collectedArtifact : collectedArtifacts.values()) {
            if (!collectedArtifact.getType().contains("gem")) continue;
            String prefix = collectedArtifact.getGroupId().equals("rubygems") ? "" : collectedArtifact.getGroupId() + ".";
            File gemDir = new File(gemsDir, prefix + collectedArtifact.getFile().getName().replaceAll(".gem$", "").replace("-SNAPSHOT", ""));
            File javaGemDir = new File(gemsDir, prefix + collectedArtifact.getFile().getName().replaceAll(".gem$", "-java").replace("-SNAPSHOT", ""));
            if (!gemDir.exists() && !javaGemDir.exists()) {
                gems.append(" ").append(collectedArtifact.getFile().getAbsolutePath());
                continue;
            }
            this.getLog().debug((CharSequence)("already installed: " + collectedArtifact));
        }
        if (gems.length() > 0) {
            Script script = this.factory.newScriptFromResource("META-INF/jruby.home/bin/gem").addArg("install");
            if (this.installRDoc) {
                script.addArg("--rdoc");
            } else {
                script.addArg("--no-rdoc");
            }
            if (this.installRI) {
                script.addArg("--ri");
            } else {
                script.addArg("--no-ri");
            }
            script.addArg("--no-user-install").addArg("-l").addArg(extraFlag).addArgs(this.gemInitializeArgs).addArgs(gems.toString()).execute();
        } else {
            this.getLog().debug((CharSequence)"no gems found to install");
        }
    }

    protected abstract void executeWithGems() throws MojoExecutionException, RubyScriptException, IOException, MojoFailureException;

    private String key(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private void collectArtifacts(Artifact artifact, Map<String, Artifact> visitedArtifacts, boolean resolve) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("<gems> collect artifacts for " + artifact));
        this.resolve(artifact);
        try {
            MavenProject project = artifact != this.project.getArtifact() ? this.builder.buildFromRepository(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository) : this.project;
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, artifact.getScope(), null));
            project.setRemoteArtifactRepositories(this.project.getRemoteArtifactRepositories());
            ArrayList<Object> artifacts = new ArrayList<Object>();
            try {
                if (resolve) {
                    ArtifactResolutionResult result = this.resolver.resolveTransitively(project.getDependencyArtifacts(), project.getArtifact(), this.project.getManagedVersionMap(), this.localRepository, this.project.getRemoteArtifactRepositories(), this.metadata);
                    project.setArtifacts(result.getArtifacts());
                    for (Artifact a : result.getArtifacts()) {
                        artifacts.add(a);
                        this.project.getArtifactMap().put(a.getGroupId() + ":" + a.getArtifactId(), a);
                    }
                } else {
                    for (Artifact artifact2 : project.getDependencyArtifacts()) {
                        artifacts.add(this.project.getArtifactMap().get(artifact2.getGroupId() + ":" + artifact2.getArtifactId()));
                    }
                }
            }
            catch (AbstractArtifactResolutionException e) {
                if (!this.getLog().isInfoEnabled()) {
                    this.getLog().debug((CharSequence)("error resolving " + project.getArtifact()), (Throwable)e);
                } else {
                    this.getLog().warn((CharSequence)("error resolving " + project.getArtifact() + "\n\tjust ignored for now . . ."), (Throwable)e);
                }
                project.setArtifacts(NO_ARTIFACTS);
            }
            for (Artifact artifact3 : artifacts) {
                if (!"gem".equals(artifact3.getType()) || visitedArtifacts.containsKey(this.key(artifact3))) continue;
                this.collectArtifacts(artifact3, visitedArtifacts, false);
            }
            visitedArtifacts.put(this.key(artifact), artifact);
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("resolve error", (Exception)((Object)e));
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Unable to build project due to an invalid dependency version: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void resolve(Artifact artifact) throws MojoExecutionException {
        if (artifact.getFile() == null || !artifact.getFile().exists()) {
            try {
                this.resolver.resolveAlways(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("resolve error " + e.getArtifact(), (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("not found " + e.getArtifact(), (Exception)((Object)e));
            }
        }
    }
}

