/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rake;

import de.saumya.mojo.Launcher;
import de.saumya.mojo.LauncherFactory;
import de.saumya.mojo.RubyScriptException;
import de.saumya.mojo.gem.AbstractGemMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;

public class RakeMojo
extends AbstractGemMojo {
    private static List<String> NO_CLASSPATH = Collections.emptyList();
    private final File rakefile = null;
    private final File outputDirectory = null;
    private final String script;
    private final String rakeArgs;
    private final String args;
    private final String rakeVersion;

    public RakeMojo() {
        this.script = null;
        this.rakeArgs = null;
        this.args = null;
        this.rakeVersion = null;
    }

    public void execute() throws MojoExecutionException {
        if (this.project.getBasedir() == null) {
            Artifact artifact = this.artifactFactory.createArtifact("rubygems", "rake", this.rakeVersion, "test", "gem");
            this.setupGems(artifact);
            String preRelease = this.rakeVersion != null && this.rakeVersion.matches(".*[a-z][A-Z].*") ? "pre" : "";
            DefaultArtifactRepository gemsRepo = new DefaultArtifactRepository("rubygems-" + preRelease + "releases", "http://gems.saumya.de/" + preRelease + "releases", (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
            this.remoteRepositories.add(gemsRepo);
        }
        super.execute();
    }

    public void executeWithGems() throws MojoExecutionException {
        this.outputDirectory.mkdirs();
        StringBuilder args = new StringBuilder();
        if (this.script != null) {
            File scriptFile = new File(this.outputDirectory, "rake_script.rb");
            try {
                FileWriter writer = new FileWriter(scriptFile);
                writer.write(this.script);
                writer.close();
            }
            catch (IOException io) {
                throw new MojoExecutionException("error writing temporary script");
            }
            args.append("-f ").append(scriptFile.getAbsolutePath());
        } else if (this.rakefile != null) {
            args.append("-f ").append(this.rakefile);
        }
        if (this.rakeArgs != null) {
            args.append(" ").append(this.rakeArgs);
        }
        if (this.args != null) {
            args.append(" ").append(this.args);
        }
        try {
            Launcher launcher = new LauncherFactory().getEmbeddedLauncher(this.verbose, NO_CLASSPATH, this.setupEnv(), this.resolveJRUBYCompleteArtifact().getFile(), this.classRealm);
            launcher.executeScript(this.launchDirectory(), this.binScript("rake").toString(), args.toString().trim().split("\\s+"));
        }
        catch (RubyScriptException e) {
            throw new MojoExecutionException("error in rake script", (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO error", (Exception)e);
        }
    }
}

