/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.rails;

import de.saumya.mojo.rails.AbstractRailsMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.sonatype.aether.RepositorySystemSession;

public class NewMojo
extends AbstractRailsMojo {
    protected String railsArgs = null;
    protected File appPath = null;
    protected String railsVersion = null;
    protected String groupId = null;
    protected String artifactVersion = null;
    private RepositorySystemSession repoSession;
    private VelocityComponent velocityComponent;
    private static final String SMALLEST_ALLOWED_RAILS_VERSION = "2.3.5";

    protected File launchDirectory() {
        File launchDirectory = super.launchDirectory();
        launchDirectory.mkdirs();
        return launchDirectory;
    }

    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        Script script;
        if (this.railsVersion.compareTo(SMALLEST_ALLOWED_RAILS_VERSION) < 0) {
            this.getLog().warn((CharSequence)"rails version before 2.3.5 might not work");
        }
        if (!this.railsVersion.startsWith("2.")) {
            throw new MojoExecutionException("given rails version is not rails2: " + this.railsVersion);
        }
        if (this.project.getBasedir() == null) {
            this.gemsInstaller.installGem("rails", this.railsVersion, this.repoSession, this.localRepository);
        }
        if (this.railsScriptFile("rails").exists() && this.appPath == null) {
            script = this.factory.newScript(this.railsScriptFile("rails"));
        } else {
            script = this.factory.newScript(this.gemsConfig.binScriptFile("rails")).addArg("_" + this.railsVersion + "_");
            if (this.appPath != null) {
                script.addArg(this.appPath.getAbsolutePath());
            }
        }
        if (this.railsArgs != null) {
            script.addArgs(this.railsArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        script.execute();
        if (this.appPath != null) {
            Pattern pattern = Pattern.compile(".*-d\\s+([a-z0-9]+).*");
            Matcher matcher = pattern.matcher(script.toString());
            String database = matcher.matches() ? matcher.group(1) : "sqlite3";
            VelocityContext context = new VelocityContext();
            context.put("groupId", (Object)this.groupId);
            context.put("artifactId", (Object)this.appPath.getName());
            context.put("version", (Object)this.artifactVersion);
            context.put("database", (Object)database);
            context.put("railsVersion", (Object)this.railsVersion);
            this.filterContent(this.appPath, context, "pom.xml");
            this.filterContent(this.appPath, context, "public/maven.html", "public/index.html");
            this.filterContent(this.appPath, context, "src/main/webapp/WEB-INF/web.xml");
            this.filterContent(this.appPath, context, "Gemfile.maven");
        }
    }

    private void filterContent(File app, VelocityContext context, String template) throws MojoExecutionException {
        this.filterContent(app, context, template, template);
    }

    private void filterContent(File app, VelocityContext context, String template, String targetName) throws MojoExecutionException {
        File templateFile = new File(app, targetName);
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/archetype-resources/" + template);
        try {
            if (input == null) {
                throw new FileNotFoundException(template);
            }
            String templateString = IOUtil.toString((InputStream)input);
            templateFile.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(templateFile);
            this.velocityComponent.getEngine().evaluate((Context)context, (Writer)fw, "velocity", templateString);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to filter " + template, (Exception)e);
        }
    }
}

