/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby9.jar;

import de.saumya.mojo.jruby9.ArtifactHelper;
import java.io.File;
import java.lang.reflect.Field;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.UnArchiver;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JarMojo
extends org.apache.maven.plugin.jar.JarMojo {
    @Parameter(defaultValue="org.jruby.mains.JarMain", required=true)
    private String mainClass;
    @Parameter(defaultValue="9.0.0.0", property="jruby.version", required=true)
    private String jrubyVersion;
    @Parameter(defaultValue="0.4.0", property="jruby-mains.version", required=true)
    private String jrubyMainsVersion;
    @Parameter(readonly=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Component
    RepositorySystem system;
    @Component(hint="zip")
    UnArchiver unzip;

    public void execute() throws MojoExecutionException {
        MavenArchiveConfiguration archive = this.getArchive();
        archive.getManifest().setMainClass(this.mainClass);
        ArtifactHelper helper = new ArtifactHelper(this.unzip, this.system, this.localRepository, this.getProject().getRemoteArtifactRepositories());
        File output = new File(this.getProject().getBuild().getOutputDirectory());
        helper.unzip(output, "org.jruby", "jruby-complete", this.jrubyVersion);
        helper.unzip(output, "org.jruby.mains", "jruby-mains", this.jrubyMainsVersion);
        super.execute();
    }

    private MavenArchiveConfiguration getArchive() throws MojoExecutionException {
        try {
            Field archiveField = ((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getDeclaredField("archive");
            archiveField.setAccessible(true);
            return (MavenArchiveConfiguration)archiveField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new MojoExecutionException("can not use reflection", e);
        }
    }
}

