/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby9.exec;

import de.saumya.mojo.jruby9.AbstractJRuby9Mojo;
import de.saumya.mojo.jruby9.JarDependencies;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="exec", requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecMojo
extends AbstractJRuby9Mojo {
    @Parameter(property="exec.script")
    protected String script = null;
    @Parameter(property="exec.file")
    protected File file = null;
    @Parameter(property="exec.command")
    protected String command = null;
    @Parameter(property="exec.outputFile")
    protected File outputFile = null;
    @Parameter(property="exec.args")
    protected String execArgs = null;
    @Parameter
    protected String[] execArgLines = null;
    @Parameter(property="gem.addProjectClasspath", defaultValue="false")
    protected boolean addProjectClasspath;

    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException {
        JarDependencies jars = new JarDependencies(this.project.getBuild().getDirectory(), "Jars_" + this.plugin.getGoalPrefix() + ".lock");
        jars.addAll((Collection)this.plugin.getArtifacts(), new JarDependencies.Filter(){

            public boolean addIt(Artifact a) {
                return a.getScope().equals("runtime") && !ExecMojo.this.project.getArtifactMap().containsKey(a.getGroupId() + ":" + a.getArtifactId());
            }
        });
        jars.addAll((Collection)this.project.getArtifacts());
        jars.generateJarsLock();
        this.factory.addEnv("JARS_HOME", this.localRepository.getBasedir());
        this.factory.addEnv("JARS_LOCK", jars.lockFilePath());
        this.factory.addSwitch("-r", "jars/setup");
        Script s = this.script != null && this.script.length() > 0 ? this.factory.newScript(this.script) : (this.file != null ? this.factory.newScript(this.file) : (this.command != null ? this.factory.newScriptFromSearchPath(this.command) : this.factory.newArguments()));
        if (this.execArgLines != null) {
            for (String arg : this.execArgLines) {
                s.addArg(arg);
            }
        }
        s.addArgs(this.execArgs);
        s.addArgs(this.args);
        if (s.isValid()) {
            if (this.outputFile != null) {
                s.executeIn(this.launchDirectory(), this.outputFile);
            } else {
                s.executeIn(this.launchDirectory());
            }
        } else {
            this.getLog().warn((CharSequence)"no arguments given. for more details see: mvn ruby:help -Ddetail -Dgoals=exec");
        }
    }
}

