/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.mains;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jruby.Main;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;

public class JRubyMain
extends Main {
    public static final String JAR_BOOTSTRAP = "jar-bootstrap.rb";
    public static final String META_INF_JAR_BOOTSTRAP = "META-INF/jar-bootstrap.rb";

    private static String[] addBootstrap(String ... args) {
        String bootstrap = null;
        if (JRubyMain.class.getClassLoader().getResource(JAR_BOOTSTRAP) != null) {
            bootstrap = "classpath:jar-bootstrap.rb";
        } else if (JRubyMain.class.getClassLoader().getResource(META_INF_JAR_BOOTSTRAP) != null) {
            bootstrap = "classpath:META-INF/jar-bootstrap.rb";
        }
        if (bootstrap == null) {
            return args;
        }
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = bootstrap;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return newArgs;
    }

    public static void main(String bundleDisableSharedGems, String currentDir, String jrubyHome, String ... args) {
        JRubyMain main = new JRubyMain(bundleDisableSharedGems, currentDir, jrubyHome);
        try {
            Main.Status status = main.run(JRubyMain.addBootstrap(args));
            if (status.isExit()) {
                System.exit(status.getStatus());
            }
        }
        catch (RaiseException rj) {
            try {
                System.exit(-1);
            }
            catch (Throwable e) {
                System.exit(-1);
            }
        }
        catch (Throwable t) {
            System.err.println(ThreadContext.createRawBacktraceStringFromThrowable((Throwable)t));
            while ((t = t.getCause()) != null) {
                System.err.println("Caused by:");
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable((Throwable)t));
            }
            System.exit(1);
        }
    }

    JRubyMain(String bundleDisableSharedGems, String currentDirectory, String jrubyHome) {
        this(bundleDisableSharedGems, currentDirectory, jrubyHome, new RubyInstanceConfig());
    }

    JRubyMain(String bundleDisableSharedGems, String currentDirectory, String jrubyHome, RubyInstanceConfig config) {
        super(config);
        config.setHardExit(true);
        config.setCurrentDirectory(currentDirectory + "/");
        config.setJRubyHome(jrubyHome);
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        env.put("JARS_HOME", currentDirectory + "/jars");
        env.put("GEM_PATH", currentDirectory + "/");
        env.put("GEM_HOME", currentDirectory + "/META-INF/jruby.home/lib/ruby/gems/shared");
        if (bundleDisableSharedGems != null) {
            env.put("BUNDLE_DISABLE_SHARED_GEMS", bundleDisableSharedGems);
        }
        config.setEnvironment(env);
        config.setLoader(JRubyMain.class.getClassLoader());
    }

    public Main.Status run(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>(Arrays.asList(args));
        this.addRequire(newArgs, "META-INF/init");
        this.addRequire(newArgs, "WEB-INF/init");
        this.addRequire(newArgs, "META-INF/bundler_shared_helpers_patch");
        return super.run(newArgs.toArray(new String[newArgs.size()]));
    }

    private void addRequire(List<String> newArgs, String name) {
        if (((Object)((Object)this)).getClass().getClassLoader().getResource(name + ".rb") != null) {
            newArgs.add(0, "-r" + name);
        }
    }
}

