/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.gem.GemArtifact;
import de.saumya.mojo.gem.GemspecWriter;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Date;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.TEST, requiresProject=false)
public class PackageMojo
extends AbstractGemMojo {
    @Parameter(defaultValue="${project.build.directory}")
    File buildDirectory;
    @Parameter(property="gemspec")
    File gemspec;
    @Parameter(property="gemspec.overwrite")
    boolean gemspecOverwrite = false;
    @Parameter
    private String date;
    @Parameter
    private String extraRdocFiles;
    @Parameter
    private String extraFiles;
    @Parameter
    private String rdocOptions;
    @Parameter
    private String requirePaths;
    @Parameter
    private String rubyforgeProject;
    @Parameter
    private String rubygemsVersion;
    @Parameter
    private String requiredRubygemsVersion;
    @Parameter
    private String bindir;
    @Parameter
    private String requiredRubyVersion;
    @Parameter
    private String postInstallMessage;
    @Parameter
    private String executables;
    @Parameter
    private String extensions;
    @Parameter
    private String platform;
    @Parameter(defaultValue="gem_hook.rb")
    private String gemHook;
    @Parameter(defaultValue="false")
    boolean includeDependencies;
    @Parameter(defaultValue="false")
    boolean useRepositoryLayout;

    private void generatePom(File source, File target) throws ScriptException, IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource("maven/tools/pom.rb");
        String baseUrl = url.toExternalForm().replace("/maven/tools/pom.rb", "");
        this.factory.newScript("def warn(*args);end;$LOAD_PATH << '" + baseUrl + "';" + "require 'maven/tools/pom';" + "puts Maven::Tools::POM.new('" + source.getAbsolutePath() + "').to_s").executeIn(this.launchDirectory(), target);
    }

    public void executeJRuby() throws MojoExecutionException, MojoFailureException, ScriptException {
        MavenProject project = this.project;
        GemArtifact artifact = new GemArtifact(project);
        try {
            if (this.gemspec == null && project.getBasedir() != null && project.getBasedir().exists()) {
                this.buildFromPom(project, artifact);
                File pom = new File(this.project.getFile().getAbsolutePath() + ".pom");
                if (pom.exists()) {
                    this.project.setFile(pom);
                }
            } else {
                ArtifactResolutionResult jarDependencyArtifacts;
                if (this.gemspec == null) {
                    for (File f : this.launchDirectory().listFiles()) {
                        if (!f.getName().endsWith(".gemspec")) continue;
                        if (this.gemspec == null) {
                            this.gemspec = f;
                            continue;
                        }
                        throw new MojoFailureException("more than one gemspec file found, use -Dgemspec=... to specifiy one");
                    }
                    if (this.gemspec == null) {
                        throw new MojoFailureException("no gemspec file or pom found, use -Dgemspec=... to specifiy a gemspec file or '-f ...' to use a pom file");
                    }
                    this.getLog().info((CharSequence)("use gemspec: " + this.gemspec));
                }
                if ((jarDependencyArtifacts = this.includeDependencies(project, artifact)) != null) {
                    this.getLog().info((CharSequence)("use repository layout? " + this.useRepositoryLayout));
                    for (Object element : jarDependencyArtifacts.getArtifacts()) {
                        File target;
                        Artifact dependency = (Artifact)element;
                        this.getLog().info((CharSequence)(" -- include -- " + dependency));
                        if (this.useRepositoryLayout) {
                            StringBuilder path = new StringBuilder(this.libDirectory.getAbsolutePath());
                            path.append(File.separatorChar).append(dependency.getGroupId().replace(".", File.separator));
                            path.append(File.separatorChar).append(dependency.getArtifactId());
                            path.append(File.separatorChar).append(dependency.getVersion());
                            target = new File(path.toString(), dependency.getFile().getName());
                            target.getParentFile().mkdirs();
                        } else {
                            target = new File(this.libDirectory, dependency.getFile().getName());
                        }
                        FileUtils.copyFile((File)dependency.getFile(), (File)target);
                    }
                }
                this.factory.newScriptFromJRubyJar("gem").addArg("build", this.gemspec).executeIn(this.launchDirectory());
                File newPom = new File(this.gemspec.getParentFile(), "pom." + this.gemspec.getName() + ".xml");
                this.generatePom(this.gemspec, newPom);
                project.setFile(newPom);
                File gemFile = null;
                for (File f : this.launchDirectory().listFiles()) {
                    if (!f.getName().endsWith(".gem") || gemFile != null && gemFile.lastModified() >= f.lastModified()) continue;
                    gemFile = f;
                }
                if (project.getFile() != null && artifact.isGem()) {
                    FileUtils.copyFileIfModified(gemFile, (File)artifact.getFile());
                    gemFile.delete();
                } else if (this.buildDirectory.exists()) {
                    FileUtils.copyFileIfModified((File)gemFile, (File)new File(this.buildDirectory, gemFile.getName()));
                    gemFile.deleteOnExit();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("error gemifing pom", (Exception)e);
        }
    }

    private void buildFromPom(MavenProject project, GemArtifact artifact) throws MojoExecutionException, IOException, ScriptException {
        File rubyFile;
        this.getLog().info((CharSequence)("building gem for " + artifact + " . . ."));
        File gemDir = new File(this.buildDirectory, artifact.getGemName());
        File gemSpec = new File(gemDir, artifact.getGemName() + ".gemspec");
        GemspecWriter gemSpecWriter = new GemspecWriter(gemSpec, project, artifact);
        if (this.date != null) {
            gemSpecWriter.append("date", Date.valueOf(this.date).toString());
        }
        gemSpecWriter.append("rubygems_version", this.rubygemsVersion);
        gemSpecWriter.append("required_rubygems_version", this.requiredRubygemsVersion);
        gemSpecWriter.append("required_ruby_version", this.requiredRubyVersion);
        gemSpecWriter.append("bindir", this.bindir);
        gemSpecWriter.append("post_install_message", this.postInstallMessage);
        gemSpecWriter.append("rubyforge_project", this.rubyforgeProject);
        gemSpecWriter.appendRdocFiles(this.extraRdocFiles);
        gemSpecWriter.appendFiles(this.extraFiles);
        gemSpecWriter.appendList("executables", this.executables);
        gemSpecWriter.appendList("extensions", this.extensions);
        gemSpecWriter.appendList("rdoc_options", this.rdocOptions);
        gemSpecWriter.appendList("require_paths", this.requirePaths);
        if (artifact.hasJarFile()) {
            gemSpecWriter.appendPlatform(this.platform == null ? "java" : this.platform);
            gemSpecWriter.appendJarfile(artifact.getJarFile(), artifact.getJarFile().getName());
            File lib = new File(gemDir, "lib");
            lib.mkdirs();
            rubyFile = new File(lib.getName(), artifact.getGemName() + ".rb");
            gemSpecWriter.appendFile(rubyFile);
        } else {
            rubyFile = null;
            gemSpecWriter.appendPlatform(this.platform);
        }
        ArtifactResolutionResult jarDependencyArtifacts = this.includeDependencies(project, artifact);
        if (jarDependencyArtifacts != null) {
            for (Object element : jarDependencyArtifacts.getArtifacts()) {
                Artifact dependency = (Artifact)element;
                this.getLog().info((CharSequence)(" -- include -- " + dependency));
                gemSpecWriter.appendJarfile(dependency.getFile(), dependency.getFile().getName());
            }
        }
        File binDir = new File(project.getBasedir(), "bin");
        File libDir = new File(project.getBasedir(), "lib");
        File generatorsDir = new File(project.getBasedir(), "generators");
        File specDir = new File(project.getBasedir(), "spec");
        File testDir = new File(project.getBasedir(), "test");
        if (binDir.exists()) {
            gemSpecWriter.appendPath("bin");
            for (File file : binDir.listFiles()) {
                gemSpecWriter.appendExecutable(file.getName());
            }
        }
        if (libDir.exists()) {
            gemSpecWriter.appendPath("lib");
        }
        if (generatorsDir.exists()) {
            gemSpecWriter.appendPath("generators");
        }
        if (specDir.exists()) {
            gemSpecWriter.appendPath("spec");
            gemSpecWriter.appendTestPath("spec");
        }
        if (testDir.exists()) {
            gemSpecWriter.appendPath("test");
            gemSpecWriter.appendTestPath("test");
        }
        for (Dependency dependency : project.getDependencies()) {
            String prefix;
            if (dependency.isOptional() || !dependency.getType().contains("gem")) continue;
            String string = prefix = dependency.getGroupId().equals("rubygems") ? "" : dependency.getGroupId() + ".";
            if ("compileruntime".contains(dependency.getScope())) {
                gemSpecWriter.appendDependency(prefix + dependency.getArtifactId(), dependency.getVersion());
                continue;
            }
            if (!"providedtest".contains(dependency.getScope())) continue;
            gemSpecWriter.appendDevelopmentDependency(prefix + dependency.getArtifactId(), dependency.getVersion());
        }
        gemSpecWriter.close();
        gemSpecWriter.copy(gemDir);
        if (artifact.hasJarFile() && !rubyFile.exists()) {
            OutputStreamWriter writer = null;
            try {
                writer = new FileWriter(new File(gemDir, rubyFile.getPath()));
                writer.append("module ").append(this.titleizedClassname(project.getArtifactId())).append("\n");
                writer.append("  VERSION = '").append(artifact.getGemVersion()).append("'\n");
                writer.append("  MAVEN_VERSION = '").append(project.getVersion()).append("'\n");
                writer.append("end\n");
                writer.append("begin\n");
                writer.append("  require 'java'\n");
                writer.append("  require File.dirname(__FILE__) + '/").append(artifact.getJarFile().getName()).append("'\n");
                if (jarDependencyArtifacts != null) {
                    for (Object element : jarDependencyArtifacts.getArtifacts()) {
                        Artifact dependency = (Artifact)element;
                        writer.append("  require File.dirname(__FILE__) + '/").append(dependency.getFile().getName()).append("'\n");
                    }
                }
                writer.append("rescue LoadError\n");
                writer.append("  puts 'JAR-based gems require JRuby to load. Please visit www.jruby.org.'\n");
                writer.append("  raise\n");
                writer.append("end\n");
                writer.append("\n");
                writer.append("load File.dirname(__FILE__) + '/" + this.gemHook + "' if File.exists?( File.dirname(__FILE__) + '/" + this.gemHook + "')\n");
            }
            catch (IOException e) {
                throw new MojoExecutionException("error writing ruby file", (Exception)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        File localGemspec = new File(this.launchDirectory(), gemSpec.getName());
        this.factory.newScriptFromJRubyJar("gem").addArg("build", gemSpec).executeIn(gemDir);
        if (!(localGemspec.exists() && FileUtils.contentEquals((File)localGemspec, (File)gemSpec) || !this.gemspecOverwrite)) {
            this.getLog().info((CharSequence)("overwrite gemspec '" + localGemspec.getName() + "'"));
            FileUtils.copyFile((File)gemSpec, (File)localGemspec);
        }
        StringBuilder gemFilename = new StringBuilder("rubygems".equals(artifact.getGroupId()) ? "" : artifact.getGroupId() + ".").append(artifact.getArtifactId()).append("-").append(artifact.getGemVersion()).append("java-gem".equals(artifact.getType()) || "java".equals(this.platform) ? "-java" : "").append(".gem");
        FileUtils.copyFile((File)new File(gemDir, gemFilename.toString()), (File)artifact.getFile());
    }

    private ArtifactResolutionResult includeDependencies(MavenProject project, final GemArtifact artifact) throws IOException {
        ArtifactResolutionResult jarDependencyArtifacts = null;
        this.getLog().info((CharSequence)("include dependencies? " + this.includeDependencies));
        if (this.includeDependencies) {
            ArtifactFilter filter = new ArtifactFilter(){

                public boolean include(Artifact candidate) {
                    if (candidate == artifact) {
                        return true;
                    }
                    boolean result = candidate.getType().equals("jar") && ("compile".equals(candidate.getScope()) || "runtime".equals(candidate.getScope()));
                    return result;
                }
            };
            File artifactFile = artifact.getFile();
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(project.getArtifact()).setResolveRoot(false).setLocalRepository(this.localRepository).setRemoteRepositories(project.getRemoteArtifactRepositories()).setCollectionFilter(filter).setManagedVersionMap(project.getManagedVersionMap()).setArtifactDependencies(project.getDependencyArtifacts());
            jarDependencyArtifacts = this.repositorySystem.resolve(request);
            artifact.setFile(artifactFile);
        }
        return jarDependencyArtifacts;
    }

    private String titleizedClassname(String artifactId) {
        StringBuilder name = new StringBuilder();
        for (String part : artifactId.split("-")) {
            name.append(StringUtils.capitalise((String)part));
        }
        return name.toString();
    }

    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException {
    }
}

