/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemArtifact
implements Artifact {
    private final Artifact artifact;
    private final File jarFile;

    public GemArtifact(MavenProject project) {
        this.artifact = project.getArtifact();
        this.jarFile = this.artifact.getFile();
        if (this.isGem()) {
            if (project.getBuild().getFinalName() == null || !project.getGroupId().equals("rubygems")) {
                this.artifact.setFile(new File(new File(project.getBuild().getDirectory()), this.getGemFile()));
            } else {
                this.artifact.setFile(new File(new File(project.getBuild().getDirectory()), project.getBuild().getFinalName() + ".gem"));
            }
        }
        project.setArtifact((Artifact)this);
        this.artifact.setArtifactHandler((ArtifactHandler)new GemArtifactHandler(this.artifact.getArtifactHandler()));
    }

    public String getGemName() {
        if (this.getGroupId().equals("rubygems")) {
            return this.getArtifactId();
        }
        StringBuilder name = new StringBuilder(this.getGroupId());
        name.append(".").append(this.getArtifactId());
        return name.toString();
    }

    public String getGemVersion() {
        return GemArtifact.getGemVersion(this.getVersion());
    }

    public static String getGemVersion(String artifactVersion) {
        StringBuilder version = new StringBuilder();
        boolean first = true;
        for (String part : artifactVersion.replaceAll("-SNAPSHOT", "").replace("-", ".").split("\\.")) {
            if (part.length() <= 0) continue;
            if (first) {
                first = false;
                version.append(part);
                continue;
            }
            version.append(".").append(part);
        }
        return version.toString();
    }

    public String getGemFile() {
        StringBuilder name = new StringBuilder(this.getGemName());
        name.append("-").append(this.getGemVersion());
        if (this.hasJarFile()) {
            name.append("-java");
        }
        name.append(".gem");
        return name.toString();
    }

    public File getFile() {
        return this.artifact.getFile();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public boolean hasJarFile() {
        return "java-gem".equals(this.getType());
    }

    public File getJarFile() {
        if (this.hasJarFile()) {
            return this.jarFile;
        }
        return null;
    }

    public void addMetadata(ArtifactMetadata metadata) {
        this.artifact.addMetadata(metadata);
    }

    public int compareTo(Artifact o) {
        return this.artifact.compareTo((Object)o);
    }

    public ArtifactHandler getArtifactHandler() {
        return this.artifact.getArtifactHandler();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public List<ArtifactVersion> getAvailableVersions() {
        return this.artifact.getAvailableVersions();
    }

    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    public String getDependencyConflictId() {
        return this.artifact.getDependencyConflictId();
    }

    public ArtifactFilter getDependencyFilter() {
        return this.artifact.getDependencyFilter();
    }

    public List<String> getDependencyTrail() {
        return this.artifact.getDependencyTrail();
    }

    public String getDownloadUrl() {
        return this.artifact.getDownloadUrl();
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getId() {
        return this.artifact.getId();
    }

    public Collection<ArtifactMetadata> getMetadataList() {
        return this.artifact.getMetadataList();
    }

    public ArtifactRepository getRepository() {
        return this.artifact.getRepository();
    }

    public String getScope() {
        return this.artifact.getScope();
    }

    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.artifact.getSelectedVersion();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getVersion() {
        return this.artifact.getVersion();
    }

    public VersionRange getVersionRange() {
        return this.artifact.getVersionRange();
    }

    public boolean hasClassifier() {
        return this.getClassifier() != null;
    }

    public boolean isOptional() {
        return this.artifact.isOptional();
    }

    public boolean isRelease() {
        return this.artifact.isRelease();
    }

    public boolean isResolved() {
        return this.artifact.isResolved();
    }

    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.artifact.isSelectedVersionKnown();
    }

    public boolean isSnapshot() {
        return this.artifact.getVersion().matches(".*[a-zA-Z].*");
    }

    public void selectVersion(String version) {
        this.artifact.selectVersion(version);
    }

    public void setArtifactHandler(ArtifactHandler handler) {
        this.artifact.setArtifactHandler(handler);
    }

    public void setArtifactId(String artifactId) {
        this.artifact.setArtifactId(artifactId);
    }

    public void setAvailableVersions(List<ArtifactVersion> versions) {
        this.artifact.setAvailableVersions(versions);
    }

    public void setBaseVersion(String baseVersion) {
        this.artifact.setBaseVersion(baseVersion);
    }

    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.artifact.setDependencyFilter(artifactFilter);
    }

    public void setDependencyTrail(List<String> dependencyTrail) {
        this.artifact.setDependencyTrail(dependencyTrail);
    }

    public void setDownloadUrl(String downloadUrl) {
        this.artifact.setDownloadUrl(downloadUrl);
    }

    public void setFile(File destination) {
        this.artifact.setFile(destination);
    }

    public void setGroupId(String groupId) {
        this.artifact.setGroupId(groupId);
    }

    public void setOptional(boolean optional) {
        this.artifact.setOptional(optional);
    }

    public void setRelease(boolean release) {
        this.artifact.setRelease(release);
    }

    public void setRepository(ArtifactRepository remoteRepository) {
        this.artifact.setRepository(remoteRepository);
    }

    public void setResolved(boolean resolved) {
        this.artifact.setResolved(resolved);
    }

    public void setResolvedVersion(String version) {
        this.artifact.setResolvedVersion(version);
    }

    public void setScope(String scope) {
        this.artifact.setScope(scope);
    }

    public void setVersion(String version) {
        this.artifact.setVersion(version);
    }

    public void setVersionRange(VersionRange newRange) {
        this.artifact.setVersionRange(newRange);
    }

    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.artifact.updateVersion(version, localRepository);
    }

    public String toString() {
        return this.artifact.toString();
    }

    public boolean isGem() {
        return this.artifact.getType().contains("gem");
    }

    static class GemArtifactHandler
    implements ArtifactHandler {
        private final ArtifactHandler handler;

        GemArtifactHandler(ArtifactHandler handler) {
            this.handler = handler;
        }

        public String getClassifier() {
            return this.handler.getClassifier();
        }

        public String getDirectory() {
            return this.handler.getDirectory();
        }

        public String getExtension() {
            if (this.handler.getExtension().equals("java-gem")) {
                return "gem";
            }
            return this.handler.getExtension();
        }

        public String getLanguage() {
            return this.handler.getLanguage();
        }

        public String getPackaging() {
            return this.handler.getPackaging();
        }

        public boolean isAddedToClasspath() {
            return this.handler.isAddedToClasspath();
        }

        public boolean isIncludesDependencies() {
            return this.handler.isIncludesDependencies();
        }
    }
}

