/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;

public class PomMojo
extends AbstractJRubyMojo {
    PluginDescriptor plugin;
    protected File pom;
    protected boolean force = false;
    protected File gemspec;
    protected File gemfile;

    public void executeJRuby() throws MojoExecutionException, ScriptException, IOException {
        String type;
        File file;
        if (this.pom.exists() && !this.force) {
            this.getLog().info((CharSequence)(this.pom.getName() + " already exists. use '-Dpom.force=true' to overwrite"));
            return;
        }
        if (!this.gemfile.exists()) {
            this.gemfile = null;
            if (this.gemspec == null) {
                this.getLog().debug((CharSequence)"no gemspec file given, see if there is single one");
                for (File file2 : (this.project.getBasedir() == null ? new File(".") : this.project.getBasedir()).listFiles()) {
                    if (!file2.getName().endsWith(".gemspec")) continue;
                    if (this.gemspec != null) {
                        this.getLog().info((CharSequence)"there is no gemspec file given but there are more then one in the current directory.");
                        this.getLog().info((CharSequence)"use '-Dpom.gemspec=...' to select the gemspec file or -Dpom.gemfile to select a Gemfile to process");
                        break;
                    }
                    this.gemspec = file2;
                }
            }
        }
        if (this.gemspec == null && this.gemfile == null) {
            this.getLog().info((CharSequence)"no gemspec file or Gemfile. nothing to do.");
            return;
        }
        if (this.gemspec == null) {
            file = this.gemfile;
            type = "gemfile";
        } else {
            file = this.gemspec;
            type = "gemspec";
        }
        if (!this.pom.exists() || file.lastModified() <= this.pom.lastModified() || this.force) {
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)"create pom using following versions:");
                this.getLog().info((CharSequence)("\tjruby-plugins-version: " + this.plugin.getVersion()));
                this.getLog().info((CharSequence)("\tjruby-version: " + this.jrubyVersion));
            }
            this.factory.newScriptFromResource("maven/tools/pom_generator.rb").addArg(type).addArg(file).addArg(this.plugin.getVersion()).addArg(this.jrubyVersion).executeIn(this.launchDirectory(), this.pom);
        } else if (this.jrubyVerbose) {
            this.getLog().info((CharSequence)("pom is newer then " + type + ". skip creation of pom. force creation with -Dpom.force"));
        }
    }
}

