/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.gem.GemArtifact;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class InstallMojo
extends AbstractGemMojo {
    protected String installArgs = null;
    protected File gem = null;

    public void executeWithGems() throws MojoExecutionException, ScriptException, IOException, MojoFailureException {
        Script script = this.factory.newScriptFromResource("META-INF/jruby.home/bin/gem").addArg("install");
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && this.project.getArtifact().getFile().exists()) {
            GemArtifact gemArtifact = new GemArtifact(this.project);
            script.addArgs(this.installArgs).addArgs(this.args).addArg((this.installRDoc ? "--" : "--no-") + "rdoc").addArg((this.installRI ? "--" : "--no-") + "ri");
            if (gemArtifact.isGem()) {
                script.addArg("-l", gemArtifact.getFile());
            }
            script.execute();
        } else {
            if (this.gem == null) {
                for (File f : this.launchDirectory().listFiles()) {
                    if (!f.getName().endsWith(".gem")) continue;
                    if (this.gem == null) {
                        this.gem = f;
                        continue;
                    }
                    throw new MojoFailureException("more than one gem file found, use -Dgem=... to specifiy one");
                }
                if (this.gem != null) {
                    this.getLog().info((CharSequence)("use gem: " + this.gem));
                    script.addArg((this.installRDoc ? "--" : "--no-") + "rdoc").addArg((this.installRI ? "--" : "--no-") + "ri").addArg("-l", this.gem);
                }
            }
            script.addArgs(this.installArgs);
            script.addArgs(this.args);
            script.execute();
        }
    }
}

