/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "de.saumya.mojo:gem-maven-plugin:0.25.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Gem Maven Mojo", 0);
        this.append(sb, "shared dependencies and plugins for the mojos", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 12 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "exec".equals(this.goal)) {
            this.append(sb, "gem:exec", 0);
            this.append(sb, "executes a ruby script in context of the gems from pom. the arguments for jruby are build like this: ${jruby.args} ${exec.file} ${exec.args} ${args}\nto execute an inline script the exec parameters are ignored.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "execArgs (Default: ${exec.args})", 2);
                this.append(sb, "arguments for the ruby script given through file parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "file (Default: ${exec.file})", 2);
                this.append(sb, "ruby file which gets executed in context of the given gems..", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile (Default: ${jruby.outputFile})", 2);
                this.append(sb, "output file where the standard out will be written", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "script (Default: ${exec.script})", 2);
                this.append(sb, "ruby code from the pom configuration part which gets executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "execute_in_phase".equals(this.goal)) {
            this.append(sb, "gem:execute_in_phase", 0);
            this.append(sb, "the mojo allows to embed a plugin inside a Gemfile (from bundler) and execute it during the specified phase. this primary meant for the Gemfile DSL extension for polyglot maven which can use a Gemfile as POM.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "file (Default: Mavenfile)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "phase (Default: ${phase.name})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "gem".equals(this.goal)) {
            this.append(sb, "gem:gem", 0);
            this.append(sb, "goal to run gem with the given arguments.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command of JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "gemify".equals(this.goal)) {
            this.append(sb, "gem:gemify", 0);
            this.append(sb, "goal to convert that artifact into a gem.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "artifactId (Default: ${artifactId})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemify (Default: ${project.build.directory}/gemify)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupId (Default: ${groupId})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipGemInstall (Default: ${skipGemInstall})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version (Default: ${version})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "gem:help", 0);
            this.append(sb, "Display help information on gem-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0gem:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "initialize".equals(this.goal)) {
            this.append(sb, "gem:initialize", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "gem:install", 0);
            this.append(sb, "goal to locally install a given gem", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gem (Default: ${gem})", 2);
                this.append(sb, "gem file to install locally.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installArgs (Default: ${install.args})", 2);
                this.append(sb, "arguments for the 'gem install' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "irb".equals(this.goal)) {
            this.append(sb, "gem:irb", 0);
            this.append(sb, "maven wrpper around IRB.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "irbArgs (Default: ${irb.args})", 2);
                this.append(sb, "arguments for the irb command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "swing (Default: ${irb.swing})", 2);
                this.append(sb, "launch IRB in a swing window.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "gem:list", 0);
            this.append(sb, "Deprecated: just not really needed, use 'gem:gem -Dargs=list' instead goal to run 'gem list'.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package".equals(this.goal)) {
            this.append(sb, "gem:package", 0);
            this.append(sb, "goal to convert that artifact into a gem.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindir", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "binDirectory", 2);
                this.append(sb, "directory of JRuby bin path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildDirectory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "date", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "executables", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "extensions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraRdocFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemArgs (Default: ${gem.args})", 2);
                this.append(sb, "arguments for the gem command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHome (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of gem home to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemHook (Default: gem_hook.rb)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemPath (Default: ${project.build.directory}/rubygems)", 2);
                this.append(sb, "directory of JRuby path to use when forking JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemspec (Default: ${gemspec})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemspecOverwrite (Default: ${gemspec.overwrite})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeDependencies", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeOpenSSL (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRDoc (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "installRI (Default: false)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "platform", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "postInstallMessage", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rdocOptions", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "requiredRubygemsVersion", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "requiredRubyVersion", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "requirePaths", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubyforgeProject", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "rubygemsVersion", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "triggers an update of maven metadata for all gems.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "pom".equals(this.goal)) {
            this.append(sb, "gem:pom", 0);
            this.append(sb, "goal to converts a gemspec file into pom.xml.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: ${pom.force})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemfile (Default: Gemfile)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemspec (Default: ${pom.gemspec})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "plugin", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "pom (Default: pom.xml)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "spec".equals(this.goal)) {
            this.append(sb, "gem:spec", 0);
            this.append(sb, "Deprecated: just not really needed, use 'gem:gem -Dargs=spec' instead goal to run 'gem spec'.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "common arguments", 3);
                this.append(sb, "", 0);
                this.append(sb, "gemfile (Default: ${gemfile})", 2);
                this.append(sb, "arguments for the gem command of JRuby.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyArgs (Default: ${jruby.args})", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyFork (Default: true)", 2);
                this.append(sb, "fork the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyJvmArgs", 2);
                this.append(sb, "arguments for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubySwitches", 2);
                this.append(sb, "switches for the jruby command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVerbose (Default: false)", 2);
                this.append(sb, "verbose jruby related output", 3);
                this.append(sb, "", 0);
                this.append(sb, "jrubyVersion (Default: ${jruby.version})", 2);
                this.append(sb, "if the pom.xml has no runtime dependency to a jruby-complete.jar then this version is used to resolve the jruby-complete dependency from the local/remote maven repository. defaults to '1.5.6'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "launchDirectory (Default: ${launchDirectory})", 2);
                this.append(sb, "the launch directory for the JRuby execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "reference to maven project for internal use.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

