/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.gems.GemsInstaller;
import de.saumya.mojo.ruby.script.GemScriptFactory;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractGemMojo
extends AbstractJRubyMojo {
    protected boolean includeOpenSSL;
    protected boolean installRDoc;
    protected boolean installRI;
    private boolean update;
    protected File gemHome;
    protected File gemPath;
    protected String gemArgs;
    protected File binDirectory;
    protected GemManager manager;
    protected GemsConfig gemsConfig;
    protected GemsInstaller gemsInstaller;

    protected ScriptFactory newScriptFactory() throws MojoExecutionException {
        try {
            GemScriptFactory factory = new GemScriptFactory(this.logger, this.classRealm, this.resolveJRUBYCompleteArtifact().getFile(), this.project.getTestClasspathElements(), this.jrubyFork, this.gemHome, this.gemPath);
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    protected void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, ScriptException {
        if (this.project.getBasedir() == null) {
            this.gemHome = new File(this.gemHome.getAbsolutePath().replace("/${project.basedir}/", "/"));
            this.gemPath = new File(this.gemPath.getAbsolutePath().replace("/${project.basedir}/", "/"));
        }
        this.gemsConfig = new GemsConfig();
        this.gemsConfig.setAddRdoc(this.installRDoc);
        this.gemsConfig.setAddRI(this.installRI);
        this.gemsConfig.setGemHome(this.gemHome);
        this.gemsConfig.setGemPath(this.gemPath);
        this.gemsConfig.setBinDirectory(this.binDirectory);
        this.gemsConfig.setSkipJRubyOpenSSL(!this.includeOpenSSL);
        this.gemsInstaller = new GemsInstaller(this.gemsConfig, this.factory, this.manager);
        this.updateMetadata();
        try {
            this.gemsInstaller.installPom(this.project, this.localRepository);
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in installing gems", (Exception)((Object)e));
        }
        try {
            this.executeWithGems();
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in executing with gems", (Exception)((Object)e));
        }
    }

    protected abstract void executeWithGems() throws MojoExecutionException, ScriptException, GemException, IOException, MojoFailureException;

    void updateMetadata() throws MojoExecutionException {
        if (this.update) {
            ArrayList<String> done = new ArrayList<String>();
            for (ArtifactRepository repo : this.project.getRemoteArtifactRepositories()) {
                if (!repo.getId().startsWith("rubygems")) continue;
                URL url = null;
                try {
                    url = new URL(repo.getUrl() + "/update");
                    if (done.contains(url.getHost())) continue;
                    done.add(url.getHost());
                    InputStream in = url.openStream();
                    in.read();
                    in.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("error in sending update url: " + url, (Exception)e);
                }
            }
        }
    }
}

