/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.management.MBeanServer;

public class JMemoryBuddy {
    private static final int steps;
    private static final int testDuration;
    private static final int sleepDuration;
    private static final boolean createHeapdump;
    private static final int garbageAmount;
    private static String mxBeanProxyName;
    private static String outputFolderString;

    private static String getDefaultOutputFolder() {
        File folder1 = new File("target");
        File folder2 = new File("build");
        if (folder1.exists()) {
            return folder1.getAbsolutePath();
        }
        if (folder2.exists()) {
            return folder2.getAbsolutePath();
        }
        return ".";
    }

    static void createGarbage() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int counter = 0; counter < garbageAmount; ++counter) {
            list.add(1);
        }
    }

    public static void assertCollectable(WeakReference<?> weakReference) {
        if (!JMemoryBuddy.checkCollectable(weakReference)) {
            AssertCollectable assertCollectable = new AssertCollectable(weakReference);
            JMemoryBuddy.createHeapDump();
            throw new AssertionError((Object)("Content of WeakReference was not collected. content: " + weakReference.get()));
        }
    }

    public static boolean checkCollectable(WeakReference<?> weakReference) {
        return JMemoryBuddy.checkCollectable(steps, weakReference) > 0;
    }

    private static int checkCollectable(int stepsLeft, WeakReference<?> weakReference) {
        int counter = stepsLeft;
        if (weakReference.get() != null) {
            JMemoryBuddy.createGarbage();
            System.gc();
            System.runFinalization();
        }
        while (counter > 0 && weakReference.get() != null) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            --counter;
            JMemoryBuddy.createGarbage();
            System.gc();
            System.runFinalization();
        }
        if (weakReference.get() == null && counter < steps / 3) {
            int percentageUsed = (steps - counter) / steps * 100;
            System.out.println("Warning test seems to be unstable. time used: " + percentageUsed + "%");
        }
        return counter;
    }

    public static void assertNotCollectable(WeakReference<Object> weakReference) {
        if (!JMemoryBuddy.checkNotCollectable(weakReference)) {
            throw new AssertionError((Object)"Content of WeakReference was collected!");
        }
    }

    public static boolean checkNotCollectable(WeakReference<?> weakReference) {
        JMemoryBuddy.createGarbage();
        System.gc();
        System.runFinalization();
        JMemoryBuddy.createGarbage();
        System.gc();
        return weakReference.get() != null;
    }

    public static void memoryTest(Consumer<MemoryTestAPI> f) {
        final LinkedList toBeCollected = new LinkedList();
        final LinkedList toBeNotCollected = new LinkedList();
        final LinkedList toBeReferenced = new LinkedList();
        f.accept(new MemoryTestAPI(){

            @Override
            public void assertCollectable(Object ref) {
                Objects.requireNonNull(ref);
                toBeCollected.add(new WeakReference<Object>(ref));
            }

            @Override
            public void assertNotCollectable(Object ref) {
                Objects.requireNonNull(ref);
                toBeNotCollected.add(new AssertNotCollectable(ref));
            }

            @Override
            public void setAsReferenced(Object ref) {
                Objects.requireNonNull(ref);
                toBeReferenced.add(new SetAsReferenced(ref));
            }
        });
        int stepsLeft = steps;
        boolean failed = false;
        for (Object wRef : toBeCollected) {
            stepsLeft = JMemoryBuddy.checkCollectable(stepsLeft, wRef);
        }
        if (stepsLeft == 0) {
            failed = true;
        }
        for (Object wRef : toBeNotCollected) {
            if (JMemoryBuddy.checkNotCollectable(((AssertNotCollectable)wRef).getWeakReference())) continue;
            failed = true;
        }
        if (failed) {
            LinkedList<AssertCollectable> toBeCollectedMarked = new LinkedList<AssertCollectable>();
            LinkedList<Object> toBeNotCollectedMarked = new LinkedList<Object>();
            for (Object wRef : toBeCollected) {
                if (((Reference)wRef).get() == null) continue;
                toBeCollectedMarked.add(new AssertCollectable((WeakReference<?>)wRef));
            }
            for (Object wRef : toBeNotCollected) {
                if (((AssertNotCollectable)wRef).getWeakReference().get() != null) continue;
                toBeNotCollectedMarked.add(wRef);
            }
            JMemoryBuddy.createHeapDump();
            if (toBeNotCollectedMarked.isEmpty()) {
                throw new AssertionError((Object)("The following references should be collected: " + toBeCollectedMarked));
            }
            if (toBeCollectedMarked.isEmpty()) {
                throw new AssertionError((Object)("The following references should not be collected: " + toBeNotCollectedMarked));
            }
            throw new AssertionError((Object)("The following references should be collected: " + toBeCollectedMarked + " and " + toBeNotCollected.size() + " should not be collected: " + toBeNotCollectedMarked));
        }
    }

    static void createHeapDump() {
        if (createHeapdump) {
            try {
                String dateString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
                String fileName = "heapdump_jmemb_" + dateString + ".hprof";
                File outputFolder = new File(outputFolderString);
                String heapdumpFile = new File(outputFolder, fileName).getAbsolutePath();
                System.out.println("Creating Heapdump at: " + heapdumpFile);
                JMemoryBuddy.getHotspotMBean().dumpHeap(heapdumpFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No Heapdump was created. You might want to change the configuration to get a HeapDump.");
        }
    }

    private static void setMxBeanProxyName(String mxBeanName) {
        mxBeanProxyName = mxBeanName;
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return ManagementFactory.newPlatformMXBeanProxy(server, mxBeanProxyName, HotSpotDiagnosticMXBean.class);
    }

    static {
        mxBeanProxyName = "com.sun.management:type=HotSpotDiagnostic";
        outputFolderString = ".";
        outputFolderString = System.getProperty("jmemorybuddy.output", JMemoryBuddy.getDefaultOutputFolder());
        testDuration = Integer.parseInt(System.getProperty("jmemorybuddy.testDuration", "1000"));
        steps = Integer.parseInt(System.getProperty("jmemorybuddy.steps", "10"));
        createHeapdump = Boolean.parseBoolean(System.getProperty("jmemorybuddy.createHeapdump", "true"));
        garbageAmount = Integer.parseInt(System.getProperty("jmemorybuddy.garbageAmount", "99999"));
        sleepDuration = testDuration / steps;
    }

    static class AssertCollectable {
        WeakReference<?> assertCollectable;

        AssertCollectable(WeakReference<?> ref) {
            this.assertCollectable = ref;
        }

        WeakReference<?> getWeakReference() {
            return this.assertCollectable;
        }

        public String toString() {
            Object el = this.assertCollectable.get();
            return el != null ? el.toString() : "null";
        }
    }

    private static class AssertNotCollectable {
        WeakReference<?> assertNotCollectable;
        String originalResultOfToString;

        AssertNotCollectable(Object ref) {
            this.assertNotCollectable = new WeakReference<Object>(ref);
            this.originalResultOfToString = ref.toString();
        }

        WeakReference<?> getWeakReference() {
            return this.assertNotCollectable;
        }

        public String toString() {
            return this.originalResultOfToString;
        }
    }

    private static class SetAsReferenced {
        Object setAsReferenced;

        SetAsReferenced(Object ref) {
            this.setAsReferenced = ref;
        }
    }

    public static interface MemoryTestAPI {
        public void assertCollectable(Object var1);

        public void assertNotCollectable(Object var1);

        public void setAsReferenced(Object var1);
    }
}

