/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CleanupDetector {
    private static final Set<WeakReferenceWithRunnable> references = ConcurrentHashMap.newKeySet();
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static void onCleanup(Object obj, Runnable r) {
        CleanupDetector.onCleanup(new WeakReferenceWithRunnable(obj, r));
    }

    public static void onCleanup(WeakReferenceWithRunnable weakRef) {
        references.add(weakRef);
    }

    static {
        Thread cleanupDetectorThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        WeakReferenceWithRunnable r = (WeakReferenceWithRunnable)queue.remove();
                        references.remove(r);
                        r.r.run();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "JMemoryBuddy-cleanup-detector");
        cleanupDetectorThread.setDaemon(true);
        cleanupDetectorThread.start();
    }

    public static class WeakReferenceWithRunnable
    extends WeakReference<Object> {
        Runnable r;

        WeakReferenceWithRunnable(Object ref, Runnable r) {
            super(ref, queue);
            this.r = r;
        }
    }
}

