/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import de.sandec.jmemorybuddy.CleanupDetector;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JMemoryBuddyLive {
    static int collectedEntrys = 0;
    static Set<CollectableEntry> collectables = new HashSet<CollectableEntry>();

    public static synchronized void markCollectable(String name, Object ref) {
        Objects.requireNonNull(ref);
        CollectableEntry entry = new CollectableEntry(new Date(), name);
        AssertCollectableLive pRef = new AssertCollectableLive(name, ref, () -> JMemoryBuddyLive.removeCollectable(entry));
        collectables.add(entry);
        CleanupDetector.onCleanup(pRef);
    }

    private static synchronized void removeCollectable(CollectableEntry entry) {
        ++collectedEntrys;
        collectables.remove(entry);
    }

    public static synchronized Report getReport() {
        return new Report(collectedEntrys, collectables.stream().sorted((a, b) -> a.collectableSince.compareTo(b.collectableSince)).collect(Collectors.toList()));
    }

    public static class CollectableEntry {
        public Date collectableSince;
        public String name;

        CollectableEntry(Date time, String name) {
            this.collectableSince = time;
            this.name = name;
        }

        public String toString() {
            return "CollectableEntry{collectableSince=" + this.collectableSince + ", name='" + this.name + '\'' + '}';
        }
    }

    static class AssertCollectableLive
    extends CleanupDetector.WeakReferenceWithRunnable {
        String name;

        AssertCollectableLive(String name, Object ref, Runnable r) {
            super(ref, r);
            this.name = name;
        }
    }

    public static class Report {
        public int collectedEntries;
        public List<CollectableEntry> uncollectedEntries;

        Report(int collectedEntries, List<CollectableEntry> uncollectedEntries) {
            this.collectedEntries = collectedEntries;
            this.uncollectedEntries = uncollectedEntries;
        }

        public String toString() {
            return "Report{collectedEntries=" + this.collectedEntries + ", uncollectedEntries=" + this.uncollectedEntries + '}';
        }
    }
}

