/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;

public class CleanupDetector {
    private static HashSet<PhantomReferenceWithRunnable> references = new HashSet();
    private static ReferenceQueue queue = new ReferenceQueue();

    public static void onCleanup(Object obj, Runnable r) {
        CleanupDetector.onCleanup(new PhantomReferenceWithRunnable(obj, r));
    }

    public static void onCleanup(PhantomReferenceWithRunnable phantomref) {
        references.add(phantomref);
    }

    static {
        Thread cleanupDetectorThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        PhantomReferenceWithRunnable r = (PhantomReferenceWithRunnable)queue.remove();
                        references.remove(r);
                        r.r.run();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "JMemoryBuddy-cleanup-detector");
        cleanupDetectorThread.setDaemon(true);
        cleanupDetectorThread.start();
    }

    public static class PhantomReferenceWithRunnable
    extends PhantomReference {
        Runnable r = null;

        PhantomReferenceWithRunnable(Object ref, Runnable r) {
            super(ref, queue);
            this.r = r;
        }
    }
}

