/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.management.MBeanServer;

public class JMemoryBuddy {
    static int steps = 10;
    static int overallTime = 1000;
    static int sleepTime = overallTime / steps;
    private static String MX_BEAN_PROXY_TYPE = "com.sun.management:type=HotSpotDiagnostic";
    static String outputFolderString = ".";

    public static void createGarbage() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int counter = 0; counter < 999999; ++counter) {
            list.add(1);
        }
    }

    public static void assertCollectable(WeakReference weakReference) {
        if (!JMemoryBuddy.checkCollectable(weakReference)) {
            AssertCollectable assertCollectable = new AssertCollectable(weakReference);
            JMemoryBuddy.createHeapDump();
            throw new AssertionError((Object)("Content of WeakReference was not collected. content: " + weakReference.get()));
        }
    }

    public static boolean checkCollectable(WeakReference weakReference) {
        return JMemoryBuddy.checkCollectable(steps, weakReference) > 0;
    }

    private static int checkCollectable(int stepsLeft, WeakReference weakReference) {
        int counter = stepsLeft;
        if (weakReference.get() != null) {
            JMemoryBuddy.createGarbage();
            System.gc();
            System.runFinalization();
        }
        while (counter > 0 && weakReference.get() != null) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --counter;
            JMemoryBuddy.createGarbage();
            System.gc();
            System.runFinalization();
        }
        if (weakReference.get() == null && counter < steps / 3) {
            int percentageUsed = (steps - counter) / steps * 100;
            System.out.println("Warning test seems to be unstable. time used: " + percentageUsed + "%");
        }
        return counter;
    }

    public static void assertNotCollectable(WeakReference weakReference) {
        if (!JMemoryBuddy.checkNotCollectable(weakReference)) {
            throw new AssertionError((Object)"Content of WeakReference was collected!");
        }
    }

    public static boolean checkNotCollectable(WeakReference weakReference) {
        System.gc();
        return weakReference.get() != null;
    }

    public static void memoryTest(Consumer<MemoryTestAPI> f) {
        final LinkedList toBeCollected = new LinkedList();
        final LinkedList toBeNotCollected = new LinkedList();
        final LinkedList toBeReferenced = new LinkedList();
        f.accept(new MemoryTestAPI(){

            @Override
            public void assertCollectable(Object ref) {
                if (ref == null) {
                    throw new NullPointerException();
                }
                toBeCollected.add(new WeakReference<Object>(ref));
            }

            @Override
            public void assertNotCollectable(Object ref) {
                if (ref == null) {
                    throw new NullPointerException();
                }
                toBeNotCollected.add(new WeakReference<Object>(ref));
            }

            @Override
            public void setAsReferenced(Object ref) {
                if (ref == null) {
                    throw new NullPointerException();
                }
                toBeReferenced.add(new SetAsReferenced(ref));
            }
        });
        int stepsLeft = steps;
        boolean failed = false;
        for (WeakReference wRef : toBeCollected) {
            stepsLeft = JMemoryBuddy.checkCollectable(stepsLeft, wRef);
        }
        if (stepsLeft == 0) {
            failed = true;
        }
        for (WeakReference wRef : toBeNotCollected) {
            if (JMemoryBuddy.checkNotCollectable(wRef)) continue;
            failed = true;
        }
        if (failed) {
            LinkedList<AssertCollectable> toBeCollectedMarked = new LinkedList<AssertCollectable>();
            LinkedList<AssertNotCollectable> toBeNotCollectedMarked = new LinkedList<AssertNotCollectable>();
            for (WeakReference wRef : toBeCollected) {
                toBeCollectedMarked.add(new AssertCollectable(wRef));
            }
            for (WeakReference wRef : toBeNotCollected) {
                toBeNotCollectedMarked.add(new AssertNotCollectable(wRef));
            }
            JMemoryBuddy.createHeapDump();
            if (toBeNotCollectedMarked.isEmpty()) {
                throw new AssertionError((Object)("The following references should be collected: " + toBeCollectedMarked));
            }
            throw new AssertionError((Object)("The following references should be collected: " + toBeCollectedMarked + " and " + toBeNotCollectedMarked.size() + " should not be collected: "));
        }
    }

    public static void createHeapDump() {
        try {
            String dateString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            String fileName = "heapdump_jmemb_" + dateString + ".hprof";
            File outputFolder = new File(outputFolderString);
            String heapdumpFile = new File(outputFolder, fileName).getAbsolutePath();
            System.out.println("Creating Heapdump at: " + heapdumpFile);
            JMemoryBuddy.getHotspotMBean().dumpHeap(heapdumpFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setMxBeanProxyName(String mxBeanName) {
        MX_BEAN_PROXY_TYPE = mxBeanName;
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, MX_BEAN_PROXY_TYPE, HotSpotDiagnosticMXBean.class);
        return bean;
    }

    static {
        outputFolderString = System.getProperty("jmemorybuddy.output", ".");
        overallTime = Integer.parseInt(System.getProperty("jmemorybuddy.checktime", "1000"));
        steps = Integer.parseInt(System.getProperty("jmemorybuddy.steps", "10"));
    }

    static class SetAsReferenced {
        Object setAsReferenced;

        SetAsReferenced(Object ref) {
            this.setAsReferenced = ref;
        }
    }

    static class AssertNotCollectable {
        WeakReference<Object> assertNotCollectable;

        AssertNotCollectable(WeakReference<Object> ref) {
            this.assertNotCollectable = ref;
        }

        WeakReference<Object> getWeakReference() {
            return this.assertNotCollectable;
        }
    }

    static class AssertCollectable {
        WeakReference<Object> assertCollectable;

        AssertCollectable(WeakReference<Object> ref) {
            this.assertCollectable = ref;
        }

        WeakReference<Object> getWeakReference() {
            return this.assertCollectable;
        }

        public String toString() {
            Object el = this.assertCollectable.get();
            return el != null ? el.toString() : "null";
        }
    }

    public static interface MemoryTestAPI {
        public void assertCollectable(Object var1);

        public void assertNotCollectable(Object var1);

        public void setAsReferenced(Object var1);
    }
}

