/*
 * Decompiled with CFR 0.152.
 */
package de.sandec.jmemorybuddy;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.management.MBeanServer;

public class MemoryLeakUtils {
    static int steps = 10;
    static int overallTime = 5000;
    static int sleepTime = overallTime / steps;

    public static void createGarbage() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int counter = 0; counter < 999999; ++counter) {
            list.add(1);
        }
    }

    public static void assertCollectable(WeakReference weakReference) {
        int counter;
        MemoryLeakUtils.createGarbage();
        System.gc();
        for (counter = 0; counter < steps && weakReference.get() != null; ++counter) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MemoryLeakUtils.createGarbage();
            System.gc();
        }
        if (weakReference.get() != null) {
            MemoryLeakUtils.doHeapDump();
            throw new RuntimeException("Content of Weakreference was not collected. content: " + weakReference.get());
        }
        if (counter > steps / 3) {
            int percentageUsed = counter / steps * 100;
            System.out.println("Warning test seems to be unstable. time used: " + percentageUsed + "%");
        }
    }

    public static void doMemTest(Consumer<Consumer<Object>> f) {
        LinkedList toCheck = new LinkedList();
        f.accept(elem -> toCheck.add(new WeakReference<Object>(elem)));
        for (WeakReference wRef : toCheck) {
            MemoryLeakUtils.assertCollectable(wRef);
        }
    }

    public static void doHeapDump() {
        try {
            String dateString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
            String fileName = "heapdump_jmemb_" + dateString + ".hprof";
            System.out.println("Creating Heapdump at: " + new File(fileName).getAbsolutePath());
            MemoryLeakUtils.getHotspotMBean().dumpHeap(fileName, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        return bean;
    }
}

