/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.utils;

import de.samply.share.model.osse.Attribute;
import de.samply.share.model.osse.Case;
import de.samply.share.model.osse.Container;
import de.samply.share.model.osse.Entity;
import de.samply.share.model.osse.Patient;
import de.samply.share.model.osse.QueryResult;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XmlToCsv {
    private static String join(Collection<String> s, String delimiter) {
        if (s.isEmpty()) {
            return "";
        }
        Iterator<String> iter = s.iterator();
        StringBuilder buffer = new StringBuilder("\"").append(iter.next().replace("\"", "\"\"")).append("\"");
        while (iter.hasNext()) {
            buffer.append(delimiter).append("\"").append(iter.next().replace("\"", "\"\"")).append("\"");
        }
        return buffer.toString();
    }

    public void convert(QueryResult result, Writer csvWriter, Writer mappingWriter) throws IOException {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Entity entPatient : result.getEntity()) {
            Patient patient = (Patient)entPatient;
            for (Case caseOsse : patient.getCase()) {
                Properties caseFormProperties = new Properties(caseOsse.getId(), new Properties[0]);
                for (Container container : caseOsse.getContainer()) {
                    if (!container.getDesignation().startsWith("CaseForm:")) continue;
                    for (Attribute attr : container.getAttribute()) {
                        caseFormProperties.addProperty(attr.getMdrKey(), (String)attr.getValue().getValue());
                    }
                    for (Container record : container.getContainer()) {
                        if (!record.getDesignation().equals("Record")) continue;
                        Properties recordProperties = new Properties(record.getId(), new Properties[0]);
                        for (Attribute attr : record.getAttribute()) {
                            recordProperties.addProperty(attr.getMdrKey(), (String)attr.getValue().getValue());
                        }
                        caseFormProperties.addRecord(recordProperties);
                    }
                }
                int episodeFormCount = 0;
                for (Container container : caseOsse.getContainer()) {
                    if (!container.getDesignation().startsWith("Episode")) continue;
                    ++episodeFormCount;
                    String date = "";
                    for (Attribute attr : container.getAttribute()) {
                        if (!attr.getMdrKey().equals("episode-date")) continue;
                        date = (String)attr.getValue().getValue();
                    }
                    Properties episodeFormProperties = new Properties(date, new Properties[0]);
                    for (Container epiFormContainer : container.getContainer()) {
                        for (Attribute attr : epiFormContainer.getAttribute()) {
                            episodeFormProperties.addProperty(attr.getMdrKey(), (String)attr.getValue().getValue());
                        }
                        for (Container record : epiFormContainer.getContainer()) {
                            if (!record.getDesignation().equals("Record")) continue;
                            Properties recordProperties = new Properties(record.getId(), new Properties[0]);
                            for (Attribute attr : record.getAttribute()) {
                                recordProperties.addProperty(attr.getMdrKey(), (String)attr.getValue().getValue());
                            }
                            episodeFormProperties.addRecord(recordProperties);
                        }
                    }
                    lines.add(new Line(patient.getId(), caseFormProperties, episodeFormProperties));
                }
                if (caseOsse.getContainer().size() <= 0 || episodeFormCount >= true) continue;
                lines.add(new Line(patient.getId(), caseFormProperties, new Properties("", new Properties[0])));
            }
        }
        FormContainer caseContainer = new FormContainer();
        FormContainer epiContainer = new FormContainer();
        for (Line line : lines) {
            caseContainer.addForm(line.caseForm);
            epiContainer.addForm(line.epiForm);
        }
        AttributeIndex index = new AttributeIndex();
        caseContainer.finalize(index);
        index.map.put("epi-date", "episode-date");
        index.header.add("epi-date");
        epiContainer.finalize(index);
        csvWriter.append(XmlToCsv.join(index.header, ";") + "\r\n");
        for (Line line : lines) {
            ArrayList<String> values = new ArrayList<String>();
            values.add("" + line.patientId);
            values.addAll(caseContainer.getValues(line.caseForm));
            if (line.epiForm != null) {
                values.add(line.epiForm.getId());
            }
            values.addAll(epiContainer.getValues(line.epiForm));
            csvWriter.append(XmlToCsv.join(values, ";") + "\r\n");
        }
        for (String key : index.map.keySet()) {
            mappingWriter.append(key + ";" + (String)index.map.get(key) + "\r\n");
        }
    }

    private static class Properties {
        private HashMap<String, List<String>> values = new HashMap();
        private HashMap<String, List<Properties>> recordValues = new HashMap();
        private String id;

        public Properties(String id, Properties ... forms) {
            this.id = id;
            for (Properties props : forms) {
                for (String p : props.values.keySet()) {
                    for (String value : props.values.get(p)) {
                        this.addProperty(p, value);
                    }
                }
            }
        }

        public void addRecord(Properties recordProperties) {
            if (!this.recordValues.containsKey(recordProperties.getId())) {
                this.recordValues.put(recordProperties.getId(), new ArrayList());
            }
            this.recordValues.get(recordProperties.getId()).add(recordProperties);
        }

        public void addProperty(String urn, String value) {
            if (!this.values.containsKey(urn)) {
                this.values.put(urn, new ArrayList());
            }
            this.values.get(urn).add(value);
        }

        public List<Properties> getRecords(String key) {
            return this.recordValues.get(key);
        }

        public Set<String> getRecords() {
            return this.recordValues.keySet();
        }

        public Set<String> getKeys() {
            return this.values.keySet();
        }

        public int getSize(String key) {
            return this.values.get(key).size();
        }

        public int getRecordSize(String key) {
            return this.recordValues.get(key).size();
        }

        public List<String> get(String key) {
            return this.values.get(key);
        }

        public String getId() {
            return this.id;
        }
    }

    private static class FormContainer {
        private HashMap<String, Integer> maxLength = new HashMap();
        private HashMap<String, Integer> maxRecordLength = new HashMap();
        private HashMap<String, Integer> recordSize = new HashMap();
        private HashMap<String, List<String>> recordOrder = new HashMap();
        private List<String> keys;
        private List<String> recordKeys;

        private FormContainer() {
        }

        public void addForm(Properties form) {
            if (form == null) {
                return;
            }
            for (String key : form.getKeys()) {
                if (this.maxLength.containsKey(key)) {
                    this.maxLength.put(key, Math.max(form.getSize(key), this.maxLength.get(key)));
                    continue;
                }
                this.maxLength.put(key, form.getSize(key));
            }
            for (String key : form.getRecords()) {
                this.recordSize.put(key, form.getRecords(key).get(0).getKeys().size());
                this.recordOrder.put(key, new ArrayList<String>(form.getRecords(key).get(0).getKeys()));
                if (this.maxRecordLength.containsKey(key)) {
                    this.maxRecordLength.put(key, Math.max(form.getRecordSize(key), this.maxRecordLength.get(key)));
                    continue;
                }
                this.maxRecordLength.put(key, form.getRecordSize(key));
            }
        }

        public Collection<? extends String> getValues(Properties form) {
            int added;
            int i;
            ArrayList<String> values = new ArrayList<String>();
            for (String prop : this.keys) {
                if (form.get(prop) == null) {
                    for (i = 0; i < this.maxLength.get(prop); ++i) {
                        values.add("");
                    }
                    continue;
                }
                values.addAll(form.get(prop));
                added = form.getSize(prop);
                while (added++ < this.maxLength.get(prop)) {
                    values.add("");
                }
            }
            for (String prop : this.recordKeys) {
                if (form.getRecords(prop) == null) {
                    for (i = 0; i < this.maxRecordLength.get(prop); ++i) {
                        for (int u = 0; u < this.recordOrder.get(prop).size(); ++u) {
                            values.add("");
                        }
                    }
                    continue;
                }
                for (Properties p : form.getRecords(prop)) {
                    for (String k : this.recordOrder.get(prop)) {
                        values.addAll(p.get(k));
                    }
                }
                added = form.getRecordSize(prop);
                while (added++ < this.maxRecordLength.get(prop)) {
                    for (int i2 = 0; i2 < this.recordOrder.get(prop).size(); ++i2) {
                        values.add("");
                    }
                }
            }
            return values;
        }

        public void finalize(AttributeIndex index) {
            String label;
            int i;
            this.keys = new ArrayList<String>(this.maxLength.keySet());
            this.recordKeys = new ArrayList<String>(this.maxRecordLength.keySet());
            for (String key : this.keys) {
                if (this.maxLength.get(key) > 1) {
                    for (i = 1; i <= this.maxLength.get(key); ++i) {
                        label = "la" + index.listAttrId + "_v" + i;
                        index.header.add(label);
                    }
                    index.map.put("la" + index.listAttrId, key);
                    index.listAttrId++;
                    continue;
                }
                String label2 = "a" + index.attrId++;
                index.map.put(label2, key);
                index.header.add(label2);
            }
            for (String key : this.recordKeys) {
                for (i = 1; i <= this.maxRecordLength.get(key); ++i) {
                    label = "rec" + index.recordAttrId;
                    int u = 1;
                    for (String deKey : this.recordOrder.get(key)) {
                        index.header.add(label + "_de" + u + "_v" + i);
                        index.map.put(label + "_de" + u, key + " " + deKey);
                        ++u;
                    }
                }
                index.recordAttrId++;
            }
        }
    }

    private static class AttributeIndex {
        private HashMap<String, String> map = new HashMap();
        private int attrId = 1;
        private int listAttrId = 1;
        private int recordAttrId = 1;
        private List<String> header = new ArrayList<String>();

        public AttributeIndex() {
            this.header.add("pid");
        }
    }

    private static class Line {
        private final String patientId;
        private final Properties caseForm;
        private final Properties epiForm;

        public Line(String patientId, Properties caseForm, Properties epiForm) {
            this.patientId = patientId;
            this.caseForm = caseForm;
            this.epiForm = epiForm;
        }
    }
}

