/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.utils;

import de.samply.share.model.common.And;
import de.samply.share.model.common.Attribute;
import de.samply.share.model.common.Between;
import de.samply.share.model.common.Eq;
import de.samply.share.model.common.Error;
import de.samply.share.model.common.Geq;
import de.samply.share.model.common.In;
import de.samply.share.model.common.Leq;
import de.samply.share.model.common.Or;
import de.samply.share.model.common.Query;
import de.samply.share.model.common.View;
import de.samply.share.model.common.ViewFields;
import de.samply.share.model.common.Where;
import de.samply.share.model.osse.ObjectFactory;
import de.samply.share.model.osse.QueryResult;
import de.samply.share.model.osse.QueryResultStatistic;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QueryConverter {
    public static final Logger logger = LoggerFactory.getLogger(QueryConverter.class);
    public static final String XMLNS_PATH_COMMON = "/common/";
    public static final String XMLNS_PATH_CCP = "/ccp/";
    public static final String XMLNS_PATH_OSSE = "/osse/";

    private QueryConverter() {
    }

    public static <T> T unmarshal(String xml, JAXBContext context, Class<T> clazz) throws JAXBException {
        StringReader stringReader = new StringReader(xml);
        Object obj = context.createUnmarshaller().unmarshal((Source)new StreamSource(stringReader));
        return (T)(obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : obj);
    }

    public static <T> String marshal(T object, JAXBContext context) {
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            marshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            logger.error(String.format("Exception while marshalling", new Object[]{e}));
            return "";
        }
    }

    public static Query convertCcpQueryToCommonQuery(de.samply.share.model.ccp.Query ccpQuery) throws JAXBException {
        String ccpQueryString = QueryConverter.marshal(ccpQuery, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.Query.class}));
        ccpQueryString = ccpQueryString.replace(XMLNS_PATH_CCP, XMLNS_PATH_COMMON);
        Query commonQuery = QueryConverter.xmlToQuery(ccpQueryString);
        commonQuery = QueryConverter.insertRootGroup(commonQuery);
        return commonQuery;
    }

    public static Query convertOsseQueryToCommonQuery(de.samply.share.model.osse.Query osseQuery) throws JAXBException {
        String osseQueryString = QueryConverter.marshal(osseQuery, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Query.class}));
        osseQueryString = osseQueryString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        Query commonQuery = QueryConverter.xmlToQuery(osseQueryString);
        return commonQuery;
    }

    public static de.samply.share.model.ccp.Query convertCommonQueryToCcpQuery(Query commonQuery) throws JAXBException {
        String commonQueryString = QueryConverter.queryToXml(commonQuery);
        commonQueryString = commonQueryString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_CCP);
        de.samply.share.model.ccp.Query ccpQuery = QueryConverter.unmarshal(commonQueryString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.Query.class}), de.samply.share.model.ccp.Query.class);
        return ccpQuery;
    }

    public static de.samply.share.model.osse.Query convertCommonQueryToOsseQuery(Query commonQuery) throws JAXBException {
        String commonQueryString = QueryConverter.queryToXml(commonQuery);
        commonQueryString = commonQueryString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_OSSE);
        de.samply.share.model.osse.Query osseQuery = QueryConverter.unmarshal(commonQueryString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Query.class}), de.samply.share.model.osse.Query.class);
        return osseQuery;
    }

    public static View convertCcpViewToCommonView(de.samply.share.model.ccp.View ccpView) throws JAXBException {
        String ccpViewString = QueryConverter.marshal(ccpView, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.View.class}));
        ccpViewString = ccpViewString.replace(XMLNS_PATH_CCP, XMLNS_PATH_COMMON);
        return QueryConverter.xmlToView(ccpViewString);
    }

    public static View convertOsseViewToCommonView(de.samply.share.model.osse.View osseView) throws JAXBException {
        String osseViewString = QueryConverter.marshal(osseView, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.View.class}));
        osseViewString = osseViewString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        View commonView = QueryConverter.xmlToView(osseViewString);
        return commonView;
    }

    public static de.samply.share.model.ccp.View convertCommonViewToCcpView(View commonView) throws JAXBException {
        String commonViewString = QueryConverter.viewToXml(commonView);
        commonViewString = commonViewString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_CCP);
        de.samply.share.model.ccp.View ccpView = QueryConverter.unmarshal(commonViewString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.View.class}), de.samply.share.model.ccp.View.class);
        return ccpView;
    }

    public static de.samply.share.model.osse.View convertCommonViewToOsseView(View commonView) throws JAXBException {
        String commonViewString = QueryConverter.viewToXml(commonView);
        commonViewString = commonViewString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_OSSE);
        de.samply.share.model.osse.View osseView = QueryConverter.unmarshal(commonViewString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.View.class}), de.samply.share.model.osse.View.class);
        return osseView;
    }

    public static Error convertCcpErrorToCommonError(de.samply.share.model.ccp.Error ccpError) throws JAXBException {
        String ccpErrorString = QueryConverter.marshal(ccpError, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.Error.class}));
        ccpErrorString = ccpErrorString.replace(XMLNS_PATH_CCP, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(ccpErrorString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.ObjectFactory.class}), Error.class);
    }

    public static Error convertOsseErrorToCommonError(de.samply.share.model.osse.Error osseError) throws JAXBException {
        String osseErrorString = QueryConverter.marshal(osseError, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Error.class}));
        osseErrorString = osseErrorString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(osseErrorString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.ObjectFactory.class}), Error.class);
    }

    public static de.samply.share.model.ccp.Error convertCommonErrorToCcpError(Error commonError) throws JAXBException {
        String commonErrorString = QueryConverter.marshal(commonError, JAXBContext.newInstance((Class[])new Class[]{Error.class}));
        commonErrorString = commonErrorString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_CCP);
        de.samply.share.model.ccp.Error ccpError = QueryConverter.unmarshal(commonErrorString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.Error.class}), de.samply.share.model.ccp.Error.class);
        return ccpError;
    }

    public static de.samply.share.model.osse.Error convertCommonErrorToOsseError(Error commonError) throws JAXBException {
        String commonErrorString = QueryConverter.marshal(commonError, JAXBContext.newInstance((Class[])new Class[]{Error.class}));
        commonErrorString = commonErrorString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_OSSE);
        de.samply.share.model.osse.Error osseError = QueryConverter.unmarshal(commonErrorString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Error.class}), de.samply.share.model.osse.Error.class);
        return osseError;
    }

    public static de.samply.share.model.common.QueryResultStatistic convertOsseQueryResultStatisticToCommonQueryResult(QueryResultStatistic osseQueryResultStatistic) throws JAXBException {
        String osseQueryResultStatisticString = QueryConverter.marshal(osseQueryResultStatistic, JAXBContext.newInstance((Class[])new Class[]{QueryResultStatistic.class}));
        osseQueryResultStatisticString = osseQueryResultStatisticString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(osseQueryResultStatisticString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.ObjectFactory.class}), de.samply.share.model.common.QueryResultStatistic.class);
    }

    public static QueryResultStatistic convertCommonQrsToOsseQrs(de.samply.share.model.common.QueryResultStatistic commonQueryResultStatistic) throws JAXBException {
        String commonQueryResultStatisticString = QueryConverter.marshal(commonQueryResultStatistic, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.QueryResultStatistic.class}));
        commonQueryResultStatisticString = commonQueryResultStatisticString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_OSSE);
        QueryResultStatistic osseQueryResultStatistic = QueryConverter.unmarshal(commonQueryResultStatisticString, JAXBContext.newInstance((Class[])new Class[]{QueryResultStatistic.class}), QueryResultStatistic.class);
        return osseQueryResultStatistic;
    }

    public static String queryToXml(Query query) throws JAXBException {
        return QueryConverter.marshal(query, JAXBContext.newInstance((Class[])new Class[]{Query.class}));
    }

    public static Query xmlToQuery(String xml) throws JAXBException {
        return QueryConverter.unmarshal(xml, JAXBContext.newInstance((Class[])new Class[]{Query.class}), Query.class);
    }

    public static String viewToXml(View view) throws JAXBException {
        return QueryConverter.marshal(view, JAXBContext.newInstance((Class[])new Class[]{View.class}));
    }

    public static String viewToXml(de.samply.share.model.ccp.View view) throws JAXBException {
        return QueryConverter.marshal(view, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.View.class}));
    }

    public static View xmlToView(String xml) throws JAXBException {
        return QueryConverter.unmarshal(xml, JAXBContext.newInstance((Class[])new Class[]{View.class}), View.class);
    }

    public static de.samply.share.model.ccp.QueryResult ccpXmlToQueryResult(String xml) throws JAXBException {
        return QueryConverter.unmarshal(xml, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.ObjectFactory.class}), de.samply.share.model.ccp.QueryResult.class);
    }

    public static QueryResult osseXmlToQueryResult(String xml) throws JAXBException {
        return QueryConverter.unmarshal(xml, JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}), QueryResult.class);
    }

    public static Query insertRootGroup(Query oldQuery) {
        Serializable firstChild = null;
        try {
            firstChild = oldQuery.getWhere().getAndOrEqOrLike().get(0);
        }
        catch (Exception e) {
            logger.debug("empty query received");
        }
        if (firstChild != null && (firstChild.getClass() == And.class || firstChild.getClass() == Or.class)) {
            return oldQuery;
        }
        Query newQuery = new Query();
        And and = new And();
        Where where = new Where();
        and.getAndOrEqOrLike().addAll(oldQuery.getWhere().getAndOrEqOrLike());
        where.getAndOrEqOrLike().add(and);
        newQuery.setGroupBy(oldQuery.getGroupBy());
        newQuery.setId(oldQuery.getId());
        newQuery.setOrderBy(oldQuery.getOrderBy());
        newQuery.setWhere(where);
        return newQuery;
    }

    public static Query substituteOperators(Query query) {
        Query newQuery = new Query();
        newQuery.setGroupBy(query.getGroupBy());
        newQuery.setId(query.getId());
        newQuery.setOrderBy(query.getOrderBy());
        Where newWhere = new Where();
        try {
            newWhere.getAndOrEqOrLike().add(QueryConverter.replaceOperators(query.getWhere().getAndOrEqOrLike().get(0)));
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            logger.trace("Empty query...don't exchange anything");
        }
        newQuery.setWhere(newWhere);
        return newQuery;
    }

    private static Serializable replaceOperators(Serializable object) {
        if (object.getClass() == And.class) {
            And and = (And)object;
            And and2 = new And();
            for (Serializable o : and.getAndOrEqOrLike()) {
                Serializable o2 = QueryConverter.replaceOperators(o);
                and2.getAndOrEqOrLike().add(o2);
            }
            return and2;
        }
        if (object.getClass() == Or.class) {
            Or or = (Or)object;
            Or or2 = new Or();
            for (Serializable o : or.getAndOrEqOrLike()) {
                Serializable o2 = QueryConverter.replaceOperators(o);
                or2.getAndOrEqOrLike().add(o2);
            }
            return or2;
        }
        if (object.getClass() == Between.class) {
            return QueryConverter.replaceBetween((Between)object);
        }
        if (object.getClass() == In.class) {
            return QueryConverter.replaceIn((In)object);
        }
        return object;
    }

    private static And replaceBetween(Between between) {
        de.samply.share.model.common.ObjectFactory objectFactory = new de.samply.share.model.common.ObjectFactory();
        Attribute attrFrom = new Attribute();
        attrFrom.setMdrKey(between.getRangeAttribute().getMdrKey());
        attrFrom.setValue(objectFactory.createValue(between.getRangeAttribute().getLowerBound()));
        Geq geq = new Geq();
        geq.setAttribute(attrFrom);
        Attribute attrTo = new Attribute();
        attrTo.setMdrKey(between.getRangeAttribute().getMdrKey());
        attrTo.setValue(objectFactory.createValue(between.getRangeAttribute().getUpperBound()));
        Leq leq = new Leq();
        leq.setAttribute(attrTo);
        And and = new And();
        and.getAndOrEqOrLike().add(leq);
        and.getAndOrEqOrLike().add(geq);
        return and;
    }

    private static Or replaceIn(In in) {
        Or or = new Or();
        for (JAXBElement<String> value : in.getMultivalueAttribute().getValue()) {
            Eq eq = new Eq();
            Attribute attr = new Attribute();
            attr.setMdrKey(in.getMultivalueAttribute().getMdrKey());
            attr.setValue(value);
            eq.setAttribute(attr);
            or.getAndOrEqOrLike().add(eq);
        }
        return or;
    }

    public static View removeAttributesFromView(View view, List<String> attributes) {
        if (attributes == null || attributes.size() < 1) {
            return view;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("//*[text()='");
            stringBuilder.append(attributes.get(0));
            for (int i = 1; i < attributes.size(); ++i) {
                stringBuilder.append("' or text()='");
                stringBuilder.append(attributes.get(i));
            }
            stringBuilder.append("']");
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            XPathExpression expression = xpath.compile(stringBuilder.toString());
            String xml = QueryConverter.viewToXml(view);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document document = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
            NodeList matchingKeyNodes = (NodeList)expression.evaluate(document, XPathConstants.NODESET);
            for (int j = 0; j < matchingKeyNodes.getLength(); ++j) {
                Node operatorNode;
                Node n = matchingKeyNodes.item(j);
                Node parentNode = n.getParentNode();
                if (parentNode.getNodeName().endsWith("ViewFields")) {
                    logger.trace("This is a viewfield. Only remove the single node.");
                    parentNode.removeChild(n);
                    continue;
                }
                if (parentNode.getNodeName().endsWith("Attribute")) {
                    logger.trace("This is part of the query. Remove the whole operator node as well.");
                    operatorNode = parentNode.getParentNode().getParentNode();
                    operatorNode.removeChild(parentNode.getParentNode());
                    continue;
                }
                logger.trace("This is part of the query. Remove the whole operator node as well. There is no attribute element...only remove the direct parent.");
                operatorNode = parentNode.getParentNode();
                operatorNode.removeChild(parentNode);
            }
            QueryConverter.removeEmptyNodes(document);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            StringWriter sw = new StringWriter();
            t.transform(new DOMSource(document), new StreamResult(sw));
            return QueryConverter.xmlToView(sw.toString());
        }
        catch (IOException | JAXBException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            logger.error("Exception caught: ", e);
            logger.error("There was an error while trying to remove attributes from view. Returning original View.");
            return view;
        }
    }

    public static Query removeAttributesFromQuery(Query query, List<String> attributes) {
        View view = new View();
        view.setQuery(query);
        view.setViewFields(new ViewFields());
        view.getViewFields().getMdrKey().add("placeholder");
        view = QueryConverter.removeAttributesFromView(view, attributes);
        return view.getQuery();
    }

    public static void removeEmptyNodes(Node node) {
        boolean nodeIsWhereNode;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            QueryConverter.removeEmptyNodes(list.item(i));
        }
        boolean emptyElement = node.getNodeType() == 1 && node.getChildNodes().getLength() == 0;
        boolean emptyText = node.getNodeType() == 3 && node.getNodeValue().trim().isEmpty();
        boolean bl = nodeIsWhereNode = node.getNodeType() == 1 && node.getNodeName().contains("Where");
        if ((emptyElement || emptyText) && !nodeIsWhereNode) {
            node.getParentNode().removeChild(node);
        }
    }
}

