/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.utils;

import de.samply.share.model.ccp.Container;
import de.samply.share.model.common.Patient;
import de.samply.share.utils.QueryConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Converter {
    public static final Logger logger = LoggerFactory.getLogger(Converter.class);
    public static final String XMLNS_PATH_COMMON = "/common/";
    public static final String XMLNS_PATH_CCP = "/ccp/";
    public static final String XMLNS_PATH_OSSE = "/osse/";

    private Converter() {
    }

    public static de.samply.share.model.common.Container convertOsseContainerToCommonContainer(de.samply.share.model.osse.Container osseContainer) throws JAXBException {
        String osseContainerString = "";
        osseContainerString = QueryConverter.marshal(osseContainer, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Container.class}));
        osseContainerString = osseContainerString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(osseContainerString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.Container.class}), de.samply.share.model.common.Container.class);
    }

    public static de.samply.share.model.common.Container convertCcpContainerToCommonContainer(Container ccpContainer) throws JAXBException {
        String ccpContainerString = "";
        ccpContainerString = QueryConverter.marshal(ccpContainer, JAXBContext.newInstance((Class[])new Class[]{Container.class}));
        ccpContainerString = ccpContainerString.replace(XMLNS_PATH_CCP, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(ccpContainerString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.Container.class}), de.samply.share.model.common.Container.class);
    }

    public static Container convertCommonContainerToCcpContainer(de.samply.share.model.common.Container commonContainer) throws JAXBException {
        String commonContainerString = "";
        commonContainerString = QueryConverter.marshal(commonContainer, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.Container.class}));
        commonContainerString = commonContainerString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_CCP);
        return QueryConverter.unmarshal(commonContainerString, JAXBContext.newInstance((Class[])new Class[]{Container.class}), Container.class);
    }

    public static de.samply.share.model.osse.Container convertCommonContainerToOsseContainer(de.samply.share.model.common.Container commonContainer) throws JAXBException {
        String commonContainerString = "";
        commonContainerString = QueryConverter.marshal(commonContainer, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.common.Container.class}));
        commonContainerString = commonContainerString.replace(XMLNS_PATH_COMMON, XMLNS_PATH_OSSE);
        return QueryConverter.unmarshal(commonContainerString, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Container.class}), de.samply.share.model.osse.Container.class);
    }

    public static Patient convertOssePatientToCommonPatient(de.samply.share.model.osse.Patient patient) throws JAXBException {
        String ossePatientString = "";
        ossePatientString = QueryConverter.marshal(patient, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.osse.Patient.class}));
        ossePatientString = ossePatientString.replace(XMLNS_PATH_OSSE, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(ossePatientString, JAXBContext.newInstance((Class[])new Class[]{Patient.class}), Patient.class);
    }

    public static Patient convertCcpPatientToCommonPatient(de.samply.share.model.ccp.Patient patient) throws JAXBException {
        String ccpPatientString = "";
        ccpPatientString = QueryConverter.marshal(patient, JAXBContext.newInstance((Class[])new Class[]{de.samply.share.model.ccp.Patient.class}));
        ccpPatientString = ccpPatientString.replace(XMLNS_PATH_CCP, XMLNS_PATH_COMMON);
        return QueryConverter.unmarshal(ccpPatientString, JAXBContext.newInstance((Class[])new Class[]{Patient.class}), Patient.class);
    }
}

