/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.query.value;

import de.samply.share.query.enums.SimpleValueCondition;
import de.samply.share.query.value.ValueDateDto;
import de.samply.share.query.value.ValueDateTimeDto;
import de.samply.share.query.value.ValueDecimalDto;
import de.samply.share.query.value.ValueIntegerDto;
import de.samply.share.query.value.ValuePermittedValuesDto;
import de.samply.share.query.value.ValueStringDto;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlSeeAlso(value={ValueDateDto.class, ValueIntegerDto.class, ValuePermittedValuesDto.class, ValueDecimalDto.class, ValueDateDto.class, ValueDateTimeDto.class, ValueStringDto.class})
public abstract class AbstractQueryValueDto<ValueT>
implements Serializable {
    private ValueT value;
    private ValueT maxValue;
    private SimpleValueCondition condition = SimpleValueCondition.EQUALS;

    AbstractQueryValueDto() {
    }

    AbstractQueryValueDto(ValueT defaultValue) {
        this.value = defaultValue;
        this.maxValue = defaultValue;
    }

    @XmlTransient
    public ValueT getValue() {
        return this.value;
    }

    public void setValue(ValueT value) {
        this.value = value;
    }

    @XmlTransient
    public ValueT getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(ValueT maxValue) {
        this.maxValue = maxValue;
    }

    @XmlTransient
    public String getValueAsXmlString() {
        return Objects.toString(this.value, "");
    }

    @XmlTransient
    public String getMaxValueAsXmlString() {
        return Objects.toString(this.maxValue, "");
    }

    @XmlTransient
    public String getValueAsCqlString() {
        return Objects.toString(this.value, "");
    }

    @XmlTransient
    public String getMaxValueAsCqlString() {
        return Objects.toString(this.maxValue, "");
    }

    public String getConditionShortName() {
        if (this.condition == null) {
            return "";
        }
        return this.condition.getShortName();
    }

    public SimpleValueCondition getCondition() {
        return this.condition;
    }

    public void setCondition(SimpleValueCondition condition) {
        this.condition = condition;
    }
}

