/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.essentialquery;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum EssentialValueType {
    DATE{
        private final SimpleDateFormat dateFormatXml = new SimpleDateFormat("dd.MM.yyyy");
        private final SimpleDateFormat dateFormatCql = new SimpleDateFormat("@yyyy-MM-dd");

        @Override
        public String asCqlString(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return "";
            }
            Date date = this.dateFormatXml.parse(value, new ParsePosition(0));
            if (date == null) {
                return "";
            }
            return this.dateFormatCql.format(date);
        }
    }
    ,
    DATETIME{
        private final SimpleDateFormat dateFormatXml = new SimpleDateFormat("dd.MM.yyyy'T'HH:mm:ss");
        private final SimpleDateFormat dateFormatCql = new SimpleDateFormat("@yyyy-MM-dd'T'HH:mm:ss");

        @Override
        public String asCqlString(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return "";
            }
            Date date = this.dateFormatXml.parse(value, new ParsePosition(0));
            if (date == null) {
                return "";
            }
            return this.dateFormatCql.format(date);
        }
    }
    ,
    DECIMAL,
    INTEGER,
    STRING,
    PERMITTEDVALUE;


    public String asXmlString(String value) {
        return Objects.toString(value, "");
    }

    public String asCqlString(String value) {
        return Objects.toString(value, "");
    }
}

