/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils.oauth2;

import de.samply.auth.rest.Scope;
import de.samply.auth.utils.OAuth2ClientConfig;
import de.samply.common.config.OAuth2Client;
import de.samply.common.config.ObjectFactory;
import de.samply.config.util.JaxbUtil;
import de.samply.share.common.utils.ProjectInfo;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OAuthConfig {
    protected static final String SAMPLY_OAUTH_RESPONSE_XHTML = "/samplyLogin.xhtml";
    protected static final String LOCAL_LOGOUT_REDIRECT_XHTML = "/loginRedirect.xhtml";
    private static final String IP_DKFZ = "DKFZ";
    private static final String configFilename = "OAuth2Client.xml";
    private static final String DKFZ_LOGOUT_URI = "https://adfs1.dkfz.de/adfs/ls/?wa=wsignout1.0";
    private static final Logger logger = LoggerFactory.getLogger(OAuthConfig.class);

    public static String getAuthLoginUrl() throws UnsupportedEncodingException {
        String projectName;
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        String requestedPage = context.getRequestServletPath();
        if (requestedPage != null && requestedPage.startsWith("/") && requestedPage.length() > 1 && (requestedPage = requestedPage.substring(1)).endsWith(".xhtml") && requestedPage.length() > 6) {
            requestedPage = requestedPage.substring(0, requestedPage.length() - 6);
        }
        Map requestParameterMap = context.getRequestParameterMap();
        String inquiryId = (String)requestParameterMap.get("inquiryId");
        String projectId = (String)requestParameterMap.get("projectId");
        StringBuilder sb = new StringBuilder();
        if (requestedPage != null && requestedPage.length() > 0) {
            sb.append("?requestedPage=");
            sb.append(requestedPage);
            if (inquiryId != null) {
                sb.append("&inquiryId=");
                sb.append(inquiryId);
            } else if (projectId != null) {
                sb.append("&projectId=");
                sb.append(projectId);
            }
        }
        if ((projectName = ProjectInfo.INSTANCE.getProjectName()).equalsIgnoreCase("dktk")) {
            return OAuth2ClientConfig.getRedirectUrl((OAuth2Client)OAuthConfig.getOAuth2Client(), (String)context.getRequestScheme(), (String)context.getRequestServerName(), (int)context.getRequestServerPort(), (String)context.getRequestContextPath(), (String)(SAMPLY_OAUTH_RESPONSE_XHTML + sb.toString()), (String)IP_DKFZ, (Scope[])new Scope[]{Scope.OPENID, Scope.MDR});
        }
        return OAuth2ClientConfig.getRedirectUrl((OAuth2Client)OAuthConfig.getOAuth2Client(projectName.toLowerCase(), new String[0]), (String)context.getRequestScheme(), (String)context.getRequestServerName(), (int)context.getRequestServerPort(), (String)context.getRequestContextPath(), (String)(SAMPLY_OAUTH_RESPONSE_XHTML + sb.toString()), (Scope[])new Scope[]{Scope.OPENID, Scope.MDR});
    }

    public static String getAuthLogoutUrl() throws UnsupportedEncodingException {
        String projectName = ProjectInfo.INSTANCE.getProjectName();
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        if (projectName.equalsIgnoreCase("dktk") && OAuthConfig.getOAuth2Client().getExternalIP() != null && OAuthConfig.getOAuth2Client().getExternalIP().equalsIgnoreCase("dkfz")) {
            String logoutUrl = OAuthConfig.getLogoutUrlDkfzAdfs(OAuthConfig.getOAuth2Client(), context.getRequestScheme(), context.getRequestServerName(), context.getRequestServerPort(), context.getRequestContextPath(), LOCAL_LOGOUT_REDIRECT_XHTML);
            logger.debug("LogoutURL: " + logoutUrl);
            return logoutUrl;
        }
        return OAuth2ClientConfig.getLogoutUrl((OAuth2Client)OAuthConfig.getOAuth2Client(projectName, new String[0]), (String)context.getRequestScheme(), (String)context.getRequestServerName(), (int)context.getRequestServerPort(), (String)context.getRequestContextPath(), (String)LOCAL_LOGOUT_REDIRECT_XHTML);
    }

    public static OAuth2Client getOAuth2Client() {
        return OAuthConfig.getOAuth2Client("dktk", new String[0]);
    }

    public static OAuth2Client getOAuth2Client(String projectContext, String ... fallbacks) {
        OAuth2Client oauthClient = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            oauthClient = (OAuth2Client)JaxbUtil.findUnmarshall((String)configFilename, (JAXBContext)jaxbContext, OAuth2Client.class, (String)projectContext, (String[])fallbacks);
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find config file: OAuth2Client.xml for context " + projectContext);
        }
        catch (JAXBException e) {
            logger.error("Could not read config file");
        }
        catch (SAXException e) {
            logger.error("Could not read config file");
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not read config file");
        }
        return oauthClient;
    }

    public static String getLogoutUrlDkfzAdfs(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String localRedirectUrl) throws UnsupportedEncodingException {
        String redirect = OAuth2ClientConfig.getLocalRedirectUrl((OAuth2Client)config, (String)scheme, (String)serverName, (int)port, (String)contextPath, (String)localRedirectUrl);
        String host = OAuth2ClientConfig.getHost((OAuth2Client)config, (String)serverName);
        StringBuilder builder = new StringBuilder(host);
        builder.append("/logout.xhtml?redirect_uri=").append(URLEncoder.encode(DKFZ_LOGOUT_URI, StandardCharsets.UTF_8.displayName())).append("&client_id=").append(URLEncoder.encode(config.getClientId(), StandardCharsets.UTF_8.displayName()));
        return builder.toString();
    }
}

