/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.domain.EnumElementType;
import de.samply.common.mdrclient.domain.Result;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpHost;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplyShareUtils {
    static final String ALPHANUMERICS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final Logger logger = LoggerFactory.getLogger(SamplyShareUtils.class);
    private static final String[] AVAILABLE_FORMATS = new String[]{"dd.MM.yyyy", "MM.yyyy", "yyyy"};
    private static final String[] AVAILABLE_PATTERNS = new String[]{"\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d", "\\d\\d\\.\\d\\d\\d\\d", "\\d\\d\\d\\d"};
    static Random random = new SecureRandom();

    private SamplyShareUtils() {
    }

    public static boolean isEmail(String address) {
        int pos = address.lastIndexOf("@");
        return pos > 0 && address.lastIndexOf(".") > pos && address.length() - pos > 4;
    }

    public static String getAuthCodeFromHeader(String header, String prefix) {
        if (header == null || !header.startsWith(prefix)) {
            return null;
        }
        try {
            if (prefix.endsWith(" ")) {
                return header.substring(prefix.length());
            }
            return header.substring(prefix.length() + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static String getFilesuffixFromContentDisposition(String contentDisposition) {
        return SamplyShareUtils.getFilesuffixFromFilename(SamplyShareUtils.getFilenameFromContentDisposition(contentDisposition));
    }

    public static String getFilesuffixFromFilename(String filename) {
        if (filename.indexOf(46) > 0) {
            return filename.substring(filename.lastIndexOf(46));
        }
        logger.error("Could not get file suffix from " + filename);
        return "unknown";
    }

    public static String getFilenameFromContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            logger.error("No Content-Disposition Header found");
            return "unnamed";
        }
        int start = contentDisposition.indexOf("filename");
        if (start < 0) {
            logger.error("No filename attribute found in Content-Disposition Header");
            return "unnamed";
        }
        int end = contentDisposition.indexOf("\"", start += 10);
        if (end < 0) {
            logger.error("Error finding the end of the filename attribute in Content-Disposition Header");
            return "unnamed";
        }
        String filename = contentDisposition.substring(start, end);
        return FilenameUtils.getName((String)filename);
    }

    public static Timestamp getCurrentSqlTimestamp() {
        java.util.Date nowDate = new java.util.Date();
        return new Timestamp(nowDate.getTime());
    }

    public static Time getCurrentTime() {
        Time now = new Time(new java.util.Date().getTime());
        return now;
    }

    public static Date getCurrentDate() {
        Date nowDate = new Date(new java.util.Date().getTime());
        return nowDate;
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        Date d1 = Date.valueOf(date1.toString());
        long diffInMillies = date2.getTime() - d1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static String addTrailingFileSeparator(String in) {
        String matchExpression = File.separator.equals("\\") ? File.separator + File.separator + "+$" : File.separator + "+$";
        return in.replaceAll(matchExpression, "") + File.separator;
    }

    public static String addTrailingSlash(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("/+$", "") + "/";
    }

    public static String combineUrl(String baseUrl, String ... path) {
        if (baseUrl == null) {
            logger.debug("baseUrl was null. Setting to empty String.");
            baseUrl = "";
        }
        StringBuilder stringBuilder = new StringBuilder(baseUrl.replaceAll("/+$", ""));
        for (String p : path) {
            stringBuilder.append("/");
            stringBuilder.append(p.replaceAll("/+$", "").replaceAll("^/+", ""));
        }
        return stringBuilder.toString();
    }

    public static Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public static String getVersionFromUserAgentHeader(String userAgentHeader) {
        if (userAgentHeader == null || !userAgentHeader.startsWith("Samply.Share")) {
            logger.debug("Unknown client: " + userAgentHeader);
            return null;
        }
        int slashIndex = userAgentHeader.indexOf("/");
        if (slashIndex < 0) {
            return null;
        }
        int hyphenIndex = userAgentHeader.indexOf("-", slashIndex);
        if (hyphenIndex > 0) {
            return userAgentHeader.substring(slashIndex + 1, hyphenIndex);
        }
        int spaceIndex = userAgentHeader.indexOf(" ", slashIndex);
        if (spaceIndex > 0) {
            return userAgentHeader.substring(slashIndex + 1, spaceIndex);
        }
        return userAgentHeader.substring(slashIndex + 1);
    }

    public static Integer[] convertStringListToIntegerArray(List<String> siteIdList) {
        Integer[] idArray = new Integer[siteIdList.size()];
        for (int i = 0; i < siteIdList.size(); ++i) {
            String siteId = siteIdList.get(i);
            try {
                idArray[i] = Integer.parseInt(siteId);
                continue;
            }
            catch (NumberFormatException e) {
                logger.error("Error converting String to Integer: " + siteId);
                idArray[i] = null;
            }
        }
        return idArray;
    }

    public static String convertDateStringToString(String dateString, String sourceFormatString, String targetFormatString) {
        SimpleDateFormat sourceFormat = new SimpleDateFormat(sourceFormatString);
        SimpleDateFormat targetFormat = new SimpleDateFormat(targetFormatString);
        try {
            return targetFormat.format(sourceFormat.parse(dateString));
        }
        catch (Exception e) {
            logger.warn("Could not convert date " + dateString + " from " + sourceFormatString + " to " + targetFormatString, (Throwable)e);
            return dateString;
        }
    }

    public static String convertDateStringToString(String dateString, String sourceFormatString, String targetFormatString, Locale sourceLocale, Locale targetLocale) {
        try {
            java.util.Date date = SamplyShareUtils.convertStringToDate(dateString, sourceFormatString, sourceLocale);
            return SamplyShareUtils.convertDateToString(date, targetFormatString, targetLocale);
        }
        catch (ParseException e) {
            logger.warn("Could not convert date " + dateString + " from " + sourceFormatString + " to " + targetFormatString, (Throwable)e);
            return dateString;
        }
    }

    public static String convertDateStringToString(String dateString, DateFormat sourceFormat, DateFormat targetFormat) throws ParseException {
        return targetFormat.format(sourceFormat.parse(dateString));
    }

    public static java.util.Date convertStringToDate(String dateString, String sourceFormatString, Locale sourceLocale) throws ParseException {
        SimpleDateFormat sourceFormat = new SimpleDateFormat(sourceFormatString, sourceLocale);
        return sourceFormat.parse(dateString);
    }

    public static String convertDateToString(java.util.Date date, String targetFormatString, Locale targetLocale) {
        SimpleDateFormat targetFormat = new SimpleDateFormat(targetFormatString, targetLocale);
        return targetFormat.format(date);
    }

    public static String convertSqlTimestampToString(Timestamp timestamp, DateFormat targetFormat) {
        try {
            return targetFormat.format(timestamp);
        }
        catch (Exception e) {
            logger.warn("Could not convert SQL Timestamp to String.");
            return "";
        }
    }

    public static String convertSqlTimestampToString(Timestamp timestamp, String targetFormatString) {
        SimpleDateFormat targetFormat = new SimpleDateFormat(targetFormatString);
        return SamplyShareUtils.convertSqlTimestampToString(timestamp, targetFormat);
    }

    public static Timestamp convertDateStringToSqlTimestamp(String timestampString, DateFormat sourceFormat) {
        try {
            java.util.Date date = sourceFormat.parse(timestampString);
            return new Timestamp(date.getTime());
        }
        catch (Exception e) {
            logger.warn("Could not convert SQL Timestamp to String.");
            return SamplyShareUtils.getCurrentSqlTimestamp();
        }
    }

    public static int getMonthsDiff(Date from, Date to) {
        PeriodType months = PeriodType.months();
        Period difference = new Period((ReadablePartial)new LocalDate(from.getTime()), (ReadablePartial)new LocalDate(to.getTime()), months);
        return difference.getMonths();
    }

    public static String fixPath(String in) {
        if (SamplyShareUtils.isNullOrEmpty(in)) {
            return "";
        }
        return "/" + in.replaceAll("^/+", "");
    }

    public static URL fixUrl(URL in) throws MalformedURLException {
        int port = in.getPort();
        if (port < 0) {
            port = in.getDefaultPort();
        }
        String path = SamplyShareUtils.fixPath(in.getPath());
        URL ret = new URL(in.getProtocol(), in.getHost(), port, path);
        return ret;
    }

    public static URL stringToUrl(String s) throws MalformedURLException {
        if (s.startsWith("http")) {
            return SamplyShareUtils.fixUrl(new URL(s));
        }
        return SamplyShareUtils.fixUrl(new URL("http://" + s));
    }

    public static HttpHost getAsHttpHost(String hostString) throws MalformedURLException {
        URL url = SamplyShareUtils.stringToUrl(hostString);
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    public static HttpHost getAsHttpHost(URL url) {
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static String createRandomDigitString(int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append((int)(Math.random() * 10.0));
        }
        return sb.toString();
    }

    public static String createRandomAlphanumericString(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHANUMERICS.charAt(random.nextInt(ALPHANUMERICS.length())));
        }
        return sb.toString();
    }

    public static <T> T unmarshal(String xml, JAXBContext context, Class<T> clazz) throws JAXBException {
        StringReader stringReader = new StringReader(xml);
        Object obj = context.createUnmarshaller().unmarshal((Source)new StreamSource(stringReader));
        return (T)(obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : obj);
    }

    public static <T> String marshal(T object, JAXBContext context) {
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            logger.error(String.format("Exception while marshalling", new Object[]{e}));
            return "";
        }
    }

    public static byte[] encrypt(PublicKey key, byte[] plaintext) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        cipher.init(1, key);
        return cipher.doFinal(plaintext);
    }

    public static <K, V> HashMap<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> rev = new HashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        return rev;
    }

    public static Result dataElementToResult(DataElement dataElement) {
        Result result = new Result();
        try {
            result.setId(dataElement.getIdentification().getUrn());
            result.setIdentification(dataElement.getIdentification());
            result.setDesignations(dataElement.getDesignations());
            result.setType(EnumElementType.DATAELEMENT.name());
        }
        catch (Exception e) {
            logger.error("Error converting dataElement to Result: " + dataElement, (Throwable)e);
        }
        return result;
    }

    public static java.util.Date autodiscoverDate(String sdate, Locale locale) {
        java.util.Date date = null;
        if (SamplyShareUtils.isParseable(sdate)) {
            String format;
            String[] stringArray = AVAILABLE_FORMATS;
            int n = stringArray.length;
            for (int i = 0; i < n && (date = SamplyShareUtils.getDate(sdate, format = stringArray[i], locale)) == null; ++i) {
            }
        }
        return date;
    }

    private static boolean isParseable(String sdate) {
        boolean isParseable = false;
        for (String pattern : AVAILABLE_PATTERNS) {
            if (!sdate.matches(pattern)) continue;
            isParseable = true;
            break;
        }
        return isParseable;
    }

    private static java.util.Date getDate(String date, String format, Locale locale) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, locale);
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

