/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import de.samply.share.common.model.uiquerybuilder.EnumConjunction;
import de.samply.share.common.model.uiquerybuilder.EnumOperator;
import de.samply.share.common.model.uiquerybuilder.QueryItem;
import de.samply.share.common.utils.SamplyShareUtils;
import de.samply.share.model.common.And;
import de.samply.share.model.common.Attribute;
import de.samply.share.model.common.Between;
import de.samply.share.model.common.ConditionType;
import de.samply.share.model.common.Eq;
import de.samply.share.model.common.Geq;
import de.samply.share.model.common.Gt;
import de.samply.share.model.common.In;
import de.samply.share.model.common.IsNotNull;
import de.samply.share.model.common.IsNull;
import de.samply.share.model.common.Leq;
import de.samply.share.model.common.Like;
import de.samply.share.model.common.Lt;
import de.samply.share.model.common.MultivalueAttribute;
import de.samply.share.model.common.Neq;
import de.samply.share.model.common.ObjectFactory;
import de.samply.share.model.common.Or;
import de.samply.share.model.common.Query;
import de.samply.share.model.common.RangeAttribute;
import de.samply.share.model.common.Where;
import de.samply.share.utils.QueryConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.omnifaces.model.tree.ListTreeModel;
import org.omnifaces.model.tree.TreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTreeUtil {
    private static final Logger logger = LoggerFactory.getLogger(QueryTreeUtil.class);
    private static final String CONJUNCTION_GROUP = "conjunctionGroup";

    private QueryTreeUtil() {
    }

    public static TreeModel<QueryItem> queryStringToTree(String queryString) {
        Query query = new Query();
        Where where = new Where();
        query.setWhere(where);
        if (queryString == null || queryString.length() < 1) {
            logger.error("Error...empty query String was submitted...");
            return QueryTreeUtil.queryToTree(query);
        }
        try {
            query = SamplyShareUtils.unmarshal(queryString, JAXBContext.newInstance((Class[])new Class[]{Query.class}), Query.class);
        }
        catch (JAXBException e) {
            logger.debug("JAXB Error while converting querystring to tree. Returning empty query");
        }
        return QueryTreeUtil.queryToTree(query);
    }

    public static TreeModel<QueryItem> queryToTree(Query query) {
        TreeModel<QueryItem> criteriaTree = new TreeModel<QueryItem>();
        Where where = query.getWhere();
        if (where != null) {
            for (int i = 0; i < where.getAndOrEqOrLike().size(); ++i) {
                criteriaTree = QueryTreeUtil.visitNode(criteriaTree, where.getAndOrEqOrLike().get(i));
            }
        }
        return criteriaTree;
    }

    public static boolean isQueryValid(TreeModel<QueryItem> node) {
        if (node.isLeaf()) {
            String mdrId = ((QueryItem)node.getData()).getMdrId();
            return mdrId != null && mdrId.contains(":dataelement:");
        }
        boolean hasValidChild = false;
        for (TreeModel child : node.getChildren()) {
            if (!QueryTreeUtil.isQueryValid((TreeModel<QueryItem>)child)) continue;
            hasValidChild = true;
        }
        return hasValidChild;
    }

    public static Query treeToQuery(TreeModel<QueryItem> queryTree) {
        Query query = new Query();
        Where where = new Where();
        where = (Where)QueryTreeUtil.visitNodeAndAppendToQuery(queryTree, (ConditionType)where);
        query.setWhere(where);
        try {
            logger.debug(QueryConverter.queryToXml((Query)query));
        }
        catch (JAXBException e) {
            logger.warn("Error caught while trying to serialize query. Returning empty query", (Throwable)e);
        }
        return query;
    }

    public static TreeModel<QueryItem> conditionTypeStringToTreenode(String conditionTypeString) {
        if (conditionTypeString == null || conditionTypeString.length() < 1) {
            logger.warn("Condition Type String is empty or null...bailing out");
            return new ListTreeModel();
        }
        try {
            And and = SamplyShareUtils.unmarshal(conditionTypeString, JAXBContext.newInstance((Class[])new Class[]{And.class}), And.class);
            return QueryTreeUtil.conditionTypeToTreeNode((ConditionType)and);
        }
        catch (JAXBException e) {
            logger.debug("JAXB Error while trying to unmarshall as AND. Trying OR now...");
            try {
                Or or = SamplyShareUtils.unmarshal(conditionTypeString, JAXBContext.newInstance((Class[])new Class[]{Or.class}), Or.class);
                return QueryTreeUtil.conditionTypeToTreeNode((ConditionType)or);
            }
            catch (JAXBException e1) {
                logger.error("JAXB Error: Could not convert String to ConditionType: " + conditionTypeString);
                return new ListTreeModel();
            }
        }
    }

    public static TreeModel<QueryItem> conditionTypeToTreeNode(ConditionType conditionType) {
        EnumConjunction conjunctionType = conditionType.getClass() == And.class ? EnumConjunction.AND : (conditionType.getClass() == Or.class ? EnumConjunction.OR : EnumConjunction.AND);
        QueryItem qi = new QueryItem();
        qi.setConjunction(conjunctionType);
        qi.setMdrId(CONJUNCTION_GROUP);
        qi.setRoot(false);
        ListTreeModel treeNode = new ListTreeModel();
        TreeModel<QueryItem> newNode = new TreeModel<QueryItem>();
        newNode = treeNode.addChild((Object)qi);
        for (int i = 0; i < conditionType.getAndOrEqOrLike().size(); ++i) {
            newNode = QueryTreeUtil.visitNode(newNode, conditionType.getAndOrEqOrLike().get(i));
        }
        return treeNode;
    }

    private static Object visitNodeAndAppendToQuery(TreeModel<QueryItem> node, ConditionType target) {
        if (node.isRoot()) {
            logger.trace("Visiting root");
            Where where = (Where)target;
            for (TreeModel queryItem : node.getChildren()) {
                where = (Where)QueryTreeUtil.visitNodeAndAppendToQuery((TreeModel<QueryItem>)queryItem, (ConditionType)where);
            }
            return target;
        }
        logger.trace("visiting " + node.getIndex() + " - target: " + target.getClass());
        if (node.isLeaf()) {
            if (target.getClass() == Where.class) {
                Where where = new Where();
                for (TreeModel qi : node.getChildren()) {
                    where = (Where)QueryTreeUtil.visitNodeAndAppendToQuery((TreeModel<QueryItem>)qi, (ConditionType)where);
                }
                return target;
            }
            QueryItem queryItem = (QueryItem)node.getData();
            String operatorString = "";
            if (queryItem.getOperator() == null) {
                logger.trace("operator is null");
            } else {
                operatorString = queryItem.getOperator().toString();
            }
            Attribute attribute = new Attribute();
            attribute.setMdrKey(queryItem.getMdrId());
            String dateString = queryItem.getValue();
            if (dateString != null) {
                try {
                    dateString = SamplyShareUtils.convertDateStringToString(queryItem.getValue(), new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH), new SimpleDateFormat("dd.MM.yyyy", Locale.ENGLISH));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement jaxbElement = objectFactory.createValue(dateString);
            attribute.setValue(jaxbElement);
            if (operatorString.equalsIgnoreCase(EnumOperator.EQUAL.toString())) {
                Eq eq = new Eq();
                eq.setAttribute(attribute);
                target.getAndOrEqOrLike().add(eq);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.GREATER.toString())) {
                Gt gt = new Gt();
                gt.setAttribute(attribute);
                target.getAndOrEqOrLike().add(gt);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.GREATER_OR_EQUAL.toString())) {
                Geq geq = new Geq();
                geq.setAttribute(attribute);
                target.getAndOrEqOrLike().add(geq);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.LESS_THEN.toString())) {
                Lt lt = new Lt();
                lt.setAttribute(attribute);
                target.getAndOrEqOrLike().add(lt);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.LESS_OR_EQUAL_THEN.toString())) {
                Leq leq = new Leq();
                leq.setAttribute(attribute);
                target.getAndOrEqOrLike().add(leq);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.LIKE.toString())) {
                String oldValue = (String)attribute.getValue().getValue();
                StringBuilder newValue = new StringBuilder();
                if (!oldValue.startsWith("%")) {
                    newValue.append("%");
                }
                newValue.append(oldValue);
                if (!oldValue.endsWith("%")) {
                    newValue.append("%");
                }
                attribute.setValue(objectFactory.createValue(newValue.toString()));
                Like like = new Like();
                like.setAttribute(attribute);
                target.getAndOrEqOrLike().add(like);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.NOT_EQUAL_TO.toString())) {
                Neq neq = new Neq();
                neq.setAttribute(attribute);
                target.getAndOrEqOrLike().add(neq);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.IS_NOT_NULL.toString())) {
                IsNotNull inn = new IsNotNull();
                inn.setMdrKey(attribute.getMdrKey());
                target.getAndOrEqOrLike().add(inn);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.IS_NULL.toString())) {
                IsNull in = new IsNull();
                in.setMdrKey(attribute.getMdrKey());
                target.getAndOrEqOrLike().add(in);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.BETWEEN.toString())) {
                RangeAttribute rangeAttr = new RangeAttribute();
                rangeAttr.setMdrKey(queryItem.getMdrId());
                String lowerBoundString = queryItem.getLowerBound();
                try {
                    lowerBoundString = SamplyShareUtils.convertDateStringToString(queryItem.getLowerBound(), new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH), new SimpleDateFormat("dd.MM.yyyy", Locale.ENGLISH));
                }
                catch (ParseException like) {
                    // empty catch block
                }
                String upperBoundString = queryItem.getUpperBound();
                try {
                    upperBoundString = SamplyShareUtils.convertDateStringToString(queryItem.getUpperBound(), new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH), new SimpleDateFormat("dd.MM.yyyy", Locale.ENGLISH));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                rangeAttr.setLowerBound(lowerBoundString);
                rangeAttr.setUpperBound(upperBoundString);
                Between between = new Between();
                between.setRangeAttribute(rangeAttr);
                target.getAndOrEqOrLike().add(between);
            } else if (operatorString.equalsIgnoreCase(EnumOperator.IN.toString())) {
                In in = new In();
                MultivalueAttribute mvAttr = new MultivalueAttribute();
                mvAttr.setMdrKey(queryItem.getMdrId());
                for (String value : queryItem.getValues()) {
                    jaxbElement = objectFactory.createValue(value);
                    mvAttr.getValue().add(jaxbElement);
                }
                in.setMultivalueAttribute(mvAttr);
                target.getAndOrEqOrLike().add(in);
            }
            return target;
        }
        if (((QueryItem)node.getData()).getMdrId().equalsIgnoreCase(CONJUNCTION_GROUP)) {
            QueryItem queryItem = (QueryItem)node.getData();
            if (queryItem.getConjunction().equals((Object)EnumConjunction.OR)) {
                Or or = new Or();
                for (TreeModel qi : node.getChildren()) {
                    or = (Or)QueryTreeUtil.visitNodeAndAppendToQuery((TreeModel<QueryItem>)qi, (ConditionType)or);
                }
                target.getAndOrEqOrLike().add(or);
            } else {
                And and = new And();
                for (TreeModel qi : node.getChildren()) {
                    and = (And)QueryTreeUtil.visitNodeAndAppendToQuery((TreeModel<QueryItem>)qi, (ConditionType)and);
                }
                target.getAndOrEqOrLike().add(and);
            }
            return target;
        }
        logger.error("This should never be reached");
        return null;
    }

    private static TreeModel<QueryItem> visitNode(TreeModel<QueryItem> parentNode, Object obj) {
        QueryItem qi = new QueryItem();
        TreeModel<QueryItem> newNode = new TreeModel<QueryItem>();
        if (obj.getClass() == And.class) {
            qi.setConjunction(EnumConjunction.AND);
            qi.setMdrId(CONJUNCTION_GROUP);
            qi.setRoot(parentNode.isRoot());
            newNode = parentNode.addChild((Object)qi);
            for (int j = 0; j < ((And)obj).getAndOrEqOrLike().size(); ++j) {
                newNode = QueryTreeUtil.visitNode(newNode, ((And)obj).getAndOrEqOrLike().get(j));
            }
        } else if (obj.getClass() == Or.class) {
            qi.setConjunction(EnumConjunction.OR);
            qi.setMdrId(CONJUNCTION_GROUP);
            qi.setRoot(parentNode.isRoot());
            newNode = parentNode.addChild((Object)qi);
            for (int k = 0; k < ((Or)obj).getAndOrEqOrLike().size(); ++k) {
                newNode = QueryTreeUtil.visitNode(newNode, ((Or)obj).getAndOrEqOrLike().get(k));
            }
        } else if (obj.getClass() == Eq.class) {
            Eq eq = (Eq)obj;
            qi.setMdrId(eq.getAttribute().getMdrKey());
            qi.setValue((String)eq.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.EQUAL);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Geq.class) {
            Geq geq = (Geq)obj;
            qi.setMdrId(geq.getAttribute().getMdrKey());
            qi.setValue((String)geq.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.GREATER_OR_EQUAL);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Leq.class) {
            Leq leq = (Leq)obj;
            qi.setMdrId(leq.getAttribute().getMdrKey());
            qi.setValue((String)leq.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.LESS_OR_EQUAL_THEN);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Gt.class) {
            Gt gt = (Gt)obj;
            qi.setMdrId(gt.getAttribute().getMdrKey());
            qi.setValue((String)gt.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.GREATER);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Lt.class) {
            Lt lt = (Lt)obj;
            qi.setMdrId(lt.getAttribute().getMdrKey());
            qi.setValue((String)lt.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.LESS_THEN);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Like.class) {
            Like like = (Like)obj;
            qi.setMdrId(like.getAttribute().getMdrKey());
            String val = (String)like.getAttribute().getValue().getValue();
            if (val != null && val.length() > 2 && val.startsWith("%") && val.endsWith("%")) {
                val = val.substring(1, val.length() - 1);
            }
            qi.setValue(val);
            qi.setOperator(EnumOperator.LIKE);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Neq.class) {
            Neq neq = (Neq)obj;
            qi.setMdrId(neq.getAttribute().getMdrKey());
            qi.setValue((String)neq.getAttribute().getValue().getValue());
            qi.setOperator(EnumOperator.NOT_EQUAL_TO);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == IsNull.class) {
            IsNull isNull = (IsNull)obj;
            qi.setMdrId(isNull.getMdrKey());
            qi.setOperator(EnumOperator.IS_NULL);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == IsNotNull.class) {
            IsNotNull isNotNull = (IsNotNull)obj;
            qi.setMdrId(isNotNull.getMdrKey());
            qi.setOperator(EnumOperator.IS_NOT_NULL);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == Between.class) {
            Between between = (Between)obj;
            qi.setMdrId(between.getRangeAttribute().getMdrKey());
            qi.setLowerBound(between.getRangeAttribute().getLowerBound());
            qi.setUpperBound(between.getRangeAttribute().getUpperBound());
            qi.setOperator(EnumOperator.BETWEEN);
            parentNode.addChild((Object)qi);
        } else if (obj.getClass() == In.class) {
            In in = (In)obj;
            qi.setMdrId(in.getMultivalueAttribute().getMdrKey());
            qi.setIn(in.getMultivalueAttribute());
            qi.setOperator(EnumOperator.IN);
            parentNode.addChild((Object)qi);
        }
        return parentNode;
    }
}

