/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils.oauth2;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.samply.auth.client.jwt.JwtAccessToken;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.KeyLoader;
import de.samply.auth.rest.AccessTokenDto;
import de.samply.auth.rest.AccessTokenRequestDto;
import de.samply.auth.rest.KeyIdentificationDto;
import de.samply.auth.rest.SignRequestDto;
import de.samply.share.common.utils.ProjectInfo;
import de.samply.share.common.utils.oauth2.OAuthConfig;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(OAuthUtils.class);

    public static AccessTokenDto getAccessToken(Client client, String authHost, String keyId, String privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        KeyIdentificationDto identification = new KeyIdentificationDto();
        if (keyId == null || "".equalsIgnoreCase(keyId)) {
            logger.warn("keyId empty or null, returning null");
            return null;
        }
        identification.setKeyId(Integer.parseInt(keyId));
        ClientResponse response = (ClientResponse)((WebResource.Builder)client.resource(authHost + "/oauth2/signRequest").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)identification);
        if (response.getStatus() != 200) {
            logger.error("Auth.getAccessToken returned " + response.getStatus() + " on signRequest bailing out!");
            return null;
        }
        SignRequestDto signRequest = (SignRequestDto)response.getEntity(SignRequestDto.class);
        Signature sig = Signature.getInstance(signRequest.getAlgorithm());
        sig.initSign(KeyLoader.loadPrivateKey((String)privateKey));
        sig.update(signRequest.getCode().getBytes());
        String signature = Base64.encodeBase64String((byte[])sig.sign());
        AccessTokenRequestDto accessRequest = new AccessTokenRequestDto();
        accessRequest.setCode(signRequest.getCode());
        accessRequest.setSignature(signature);
        response = (ClientResponse)((WebResource.Builder)client.resource(authHost + "/oauth2/access_token").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)accessRequest);
        if (response.getStatus() != 200) {
            logger.error("Auth.getAccessToken returned " + response.getStatus() + " bailing out!");
            return null;
        }
        AccessTokenDto accessToken = (AccessTokenDto)response.getEntity(AccessTokenDto.class);
        logger.trace("Access token: " + accessToken.getAccessToken());
        return accessToken;
    }

    public static JwtAccessToken getJwtAccessToken(String authorizationHeader) {
        JwtAccessToken jwtAccesstoken = null;
        if (authorizationHeader != null) {
            String accessToken = authorizationHeader.replace("Bearer ", "");
            try {
                jwtAccesstoken = new JwtAccessToken(OAuthConfig.getOAuth2Client(ProjectInfo.INSTANCE.getProjectName(), new String[0]), accessToken);
            }
            catch (JwtException e) {
                logger.debug("Problems reading the access token: " + (Object)((Object)e));
            }
        }
        return jwtAccesstoken;
    }

    public static String getUserAuthId(String authorizationHeader) {
        String userAuthId = "";
        logger.debug("Getting user auth ID... ");
        JwtAccessToken jwtAccesstoken = OAuthUtils.getJwtAccessToken(authorizationHeader);
        if (jwtAccesstoken != null && jwtAccesstoken.isValid()) {
            userAuthId = jwtAccesstoken.getSubject();
        }
        logger.debug("User auth ID: " + userAuthId);
        return userAuthId;
    }
}

