/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import com.google.common.base.Preconditions;
import org.apache.logging.log4j.Logger;

public class PercentageLogger {
    private final Logger logger;
    private final int numberOfElements;
    private final String description;
    private int counter = 0;
    private int lastPercentage = 0;
    private boolean isStarted = false;

    public PercentageLogger(Logger logger, int numberOfElements, String description) {
        Preconditions.checkArgument((numberOfElements >= 0 ? 1 : 0) != 0, (Object)"numberOfElements is negative");
        this.logger = logger;
        this.numberOfElements = numberOfElements;
        this.description = description;
    }

    public void start() {
        this.logger.debug(this.description);
        this.isStarted = true;
    }

    public void incrementCounter() {
        int percentage;
        if (!this.isStarted) {
            this.start();
        }
        if (this.lastPercentage != (percentage = 100 * ++this.counter / this.numberOfElements)) {
            this.lastPercentage = percentage;
            if (percentage % 10 == 0) {
                this.logger.debug(percentage + " %");
            }
        }
    }
}

