/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.model.dto;

public class UserAgent {
    private String projectContext;
    private String shareName;
    private String shareVersion;
    private String ldmName;
    private String ldmVersion;
    private String idManagerName;
    private String idManagerVersion;

    public UserAgent(String projectContext, String shareName, String shareVersion, String ldmName, String ldmVersion, String idManagerName, String idManagerVersion) {
        this.projectContext = projectContext;
        this.shareName = shareName;
        this.shareVersion = shareVersion;
        this.ldmName = ldmName;
        this.ldmVersion = ldmVersion;
        this.idManagerName = idManagerName;
        this.idManagerVersion = idManagerVersion;
    }

    public UserAgent(String projectContext, String shareName, String shareVersion) {
        this.projectContext = projectContext;
        this.shareName = shareName;
        this.shareVersion = shareVersion;
    }

    public UserAgent(String userAgentString) {
        if (userAgentString == null) {
            this.projectContext = "unknown";
            this.shareName = "unknown";
            this.shareVersion = "unknown";
            return;
        }
        int ldmStart = userAgentString.indexOf("ldm=");
        int idmStart = userAgentString.indexOf("idm=");
        int ldmSlash = ldmStart > 0 ? userAgentString.indexOf(47, ldmStart) : -1;
        int idmSlash = idmStart > 0 ? userAgentString.indexOf(47, idmStart) : -1;
        int shareSlash = userAgentString.indexOf(47);
        if (shareSlash < 0) {
            this.projectContext = "unknown";
            this.shareName = "unknown";
            this.shareVersion = "unknown";
            return;
        }
        this.shareName = userAgentString.substring(0, shareSlash);
        int shareEnd = userAgentString.indexOf(32, shareSlash);
        this.shareVersion = shareEnd > 0 ? userAgentString.substring(shareSlash + 1, shareEnd) : userAgentString.substring(shareSlash + 1);
        int projectBegin = userAgentString.indexOf(40);
        int projectEnd = userAgentString.indexOf(41, projectBegin);
        if (projectBegin > 0 && projectEnd > 0) {
            this.projectContext = userAgentString.substring(projectBegin + 1, projectEnd);
        }
        if (ldmStart > 0) {
            this.ldmName = userAgentString.substring(ldmStart + 4, ldmSlash);
            int ldmEnd = userAgentString.indexOf(32, ldmSlash);
            this.ldmVersion = ldmEnd > 0 ? userAgentString.substring(ldmSlash + 1, ldmEnd) : userAgentString.substring(ldmSlash + 1);
        }
        if (idmStart > 0) {
            this.idManagerName = userAgentString.substring(idmStart + 4, idmSlash);
            int idmEnd = userAgentString.indexOf(32, idmSlash);
            this.idManagerVersion = idmEnd > 0 ? userAgentString.substring(idmSlash + 1, idmEnd) : userAgentString.substring(idmSlash + 1);
        }
    }

    public String getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(String projectContext) {
        this.projectContext = projectContext;
    }

    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    public String getShareVersion() {
        return this.shareVersion;
    }

    public void setShareVersion(String shareVersion) {
        this.shareVersion = shareVersion;
    }

    public String getLdmName() {
        return this.ldmName;
    }

    public void setLdmName(String ldmName) {
        this.ldmName = ldmName;
    }

    public String getLdmVersion() {
        return this.ldmVersion;
    }

    public void setLdmVersion(String ldmVersion) {
        this.ldmVersion = ldmVersion;
    }

    public String getIdManagerName() {
        return this.idManagerName;
    }

    public void setIdManagerName(String idManagerName) {
        this.idManagerName = idManagerName;
    }

    public String getIdManagerVersion() {
        return this.idManagerVersion;
    }

    public void setIdManagerVersion(String idManagerVersion) {
        this.idManagerVersion = idManagerVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.shareName != null) {
            builder.append(this.shareName);
        } else {
            builder.append("unknownClient");
        }
        builder.append("/");
        if (this.shareVersion != null) {
            builder.append(this.shareVersion);
        } else {
            builder.append("unknown");
        }
        if (this.projectContext != null) {
            builder.append(" (");
            builder.append(this.projectContext);
            builder.append(")");
        }
        if (this.ldmName != null || this.ldmVersion != null) {
            builder.append(" ldm=");
            if (this.ldmName != null) {
                builder.append(this.ldmName);
            } else {
                builder.append("unknown");
            }
            builder.append("/");
            if (this.ldmVersion != null) {
                builder.append(this.ldmVersion);
            } else {
                builder.append("unknown");
            }
        }
        if (this.idManagerName != null || this.idManagerVersion != null) {
            builder.append(" idm=");
            if (this.idManagerName != null) {
                builder.append(this.idManagerName);
            } else {
                builder.append("unknown");
            }
            builder.append("/");
            if (this.idManagerVersion != null) {
                builder.append(this.idManagerVersion);
            } else {
                builder.append("unknown");
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.idManagerName == null ? 0 : this.idManagerName.hashCode());
        result = 31 * result + (this.idManagerVersion == null ? 0 : this.idManagerVersion.hashCode());
        result = 31 * result + (this.ldmName == null ? 0 : this.ldmName.hashCode());
        result = 31 * result + (this.ldmVersion == null ? 0 : this.ldmVersion.hashCode());
        result = 31 * result + (this.projectContext == null ? 0 : this.projectContext.hashCode());
        result = 31 * result + (this.shareName == null ? 0 : this.shareName.hashCode());
        result = 31 * result + (this.shareVersion == null ? 0 : this.shareVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)obj;
        if (this.idManagerName == null ? other.idManagerName != null : !this.idManagerName.equals(other.idManagerName)) {
            return false;
        }
        if (this.idManagerVersion == null ? other.idManagerVersion != null : !this.idManagerVersion.equals(other.idManagerVersion)) {
            return false;
        }
        if (this.ldmName == null ? other.ldmName != null : !this.ldmName.equals(other.ldmName)) {
            return false;
        }
        if (this.ldmVersion == null ? other.ldmVersion != null : !this.ldmVersion.equals(other.ldmVersion)) {
            return false;
        }
        if (this.projectContext == null ? other.projectContext != null : !this.projectContext.equals(other.projectContext)) {
            return false;
        }
        if (this.shareName == null ? other.shareName != null : !this.shareName.equals(other.shareName)) {
            return false;
        }
        return !(this.shareVersion == null ? other.shareVersion != null : !this.shareVersion.equals(other.shareVersion));
    }
}

