/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.Slot;
import de.samply.common.mdrclient.domain.Validations;
import de.samply.share.common.model.uiquerybuilder.EnumOperator;
import de.samply.share.common.model.uiquerybuilder.QueryItem;
import de.samply.share.common.utils.DateFormats;
import de.samply.share.common.utils.MdrIdDatatype;
import de.samply.share.common.utils.SamplyShareUtils;
import de.samply.web.enums.EnumDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.omnifaces.model.tree.TreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryValidator {
    private static final Logger logger = LoggerFactory.getLogger(QueryValidator.class);
    private static final String languageCode = "de";
    private static final String DATATYPE_BOOLEAN = "BOOLEAN";
    private static final String DATATYPE_DATE = "DATE";
    private static final String SLOTNAME_JAVA_DATE_FORMAT = "JAVA_DATE_FORMAT";
    private static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    private MdrClient mdrClient;

    public QueryValidator(MdrClient mdrClient) {
        this.mdrClient = mdrClient;
    }

    public void fixBooleans(TreeModel<QueryItem> node) {
        if (node.isLeaf()) {
            String mdrId = ((QueryItem)node.getData()).getMdrId();
            String value = ((QueryItem)node.getData()).getValue();
            if (mdrId != null && mdrId.contains(":dataelement:")) {
                try {
                    String fixedValue = this.getFixedBooleanValue(mdrId, value);
                    if (!fixedValue.equals(value)) {
                        ((QueryItem)node.getData()).setValue(fixedValue);
                    }
                }
                catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
                    logger.error("exception caught.", e);
                }
            }
        } else {
            for (TreeModel child : node.getChildren()) {
                this.fixBooleans((TreeModel<QueryItem>)child);
            }
        }
    }

    private String getFixedBooleanValue(String mdrKey, String value) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        Validations validations = this.mdrClient.getDataElementValidations(mdrKey, languageCode);
        if (validations.getDatatype().equalsIgnoreCase(DATATYPE_BOOLEAN)) {
            if (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true")) {
                return Boolean.TRUE.toString();
            }
            return Boolean.FALSE.toString();
        }
        return value;
    }

    public void reformatDateToSlotFormat(TreeModel<QueryItem> node) {
        if (node.isLeaf() && node.getData() != null) {
            MdrIdDatatype mdrIdDatatype;
            try {
                mdrIdDatatype = new MdrIdDatatype(((QueryItem)node.getData()).getMdrId());
            }
            catch (Exception e) {
                mdrIdDatatype = null;
            }
            if (mdrIdDatatype != null && mdrIdDatatype.getDatatype().equalsIgnoreCase("dataelement")) {
                if (((QueryItem)node.getData()).getOperator().equals((Object)EnumOperator.IS_NOT_NULL) || ((QueryItem)node.getData()).getOperator().equals((Object)EnumOperator.IS_NULL)) {
                    return;
                }
                String value = ((QueryItem)node.getData()).getValue();
                if (((QueryItem)node.getData()).getOperator().equals((Object)EnumOperator.BETWEEN)) {
                    String lowerBound = ((QueryItem)node.getData()).getLowerBound();
                    String upperBound = ((QueryItem)node.getData()).getUpperBound();
                    try {
                        String fixedUpperBound;
                        String fixedLowerBound = this.getDateValueInSlotFormat(mdrIdDatatype.getLatestMdr(), lowerBound);
                        if (!fixedLowerBound.equals(lowerBound)) {
                            ((QueryItem)node.getData()).setLowerBound(fixedLowerBound);
                        }
                        if (!(fixedUpperBound = this.getDateValueInSlotFormat(mdrIdDatatype.getLatestMdr(), upperBound)).equals(upperBound)) {
                            ((QueryItem)node.getData()).setUpperBound(fixedUpperBound);
                        }
                    }
                    catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
                        logger.error("exception caught.", e);
                    }
                } else {
                    try {
                        String fixedValue = this.getDateValueInSlotFormat(mdrIdDatatype.getLatestMdr(), value);
                        if (!fixedValue.equals(value)) {
                            ((QueryItem)node.getData()).setValue(fixedValue);
                        }
                    }
                    catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
                        logger.error("exception caught.", e);
                    }
                }
            }
        } else {
            for (TreeModel child : node.getChildren()) {
                this.reformatDateToSlotFormat((TreeModel<QueryItem>)child);
            }
        }
    }

    public void reformatDateFromSlotFormat(TreeModel<QueryItem> node) {
        block6: {
            block5: {
                String value;
                MdrIdDatatype mdrIdDatatype;
                block7: {
                    if (!node.isLeaf() || node.getData() == null) break block5;
                    try {
                        mdrIdDatatype = new MdrIdDatatype(((QueryItem)node.getData()).getMdrId());
                    }
                    catch (Exception e) {
                        mdrIdDatatype = null;
                    }
                    value = ((QueryItem)node.getData()).getValue();
                    if (mdrIdDatatype == null || !mdrIdDatatype.getDatatype().equalsIgnoreCase("dataelement")) break block6;
                    if (!((QueryItem)node.getData()).getOperator().equals((Object)EnumOperator.BETWEEN)) break block7;
                    String lowerBound = ((QueryItem)node.getData()).getLowerBound();
                    String upperBound = ((QueryItem)node.getData()).getUpperBound();
                    String fixedLowerBound = this.getDateValueInDefaultFormat(mdrIdDatatype.getLatestMdr(), lowerBound);
                    if (!fixedLowerBound.equals(lowerBound)) {
                        ((QueryItem)node.getData()).setLowerBound(fixedLowerBound);
                    }
                    logger.error("upperbound is " + upperBound);
                    String fixedUpperBound = this.getDateValueInDefaultFormat(mdrIdDatatype.getLatestMdr(), upperBound, true);
                    logger.error("fixed upperbound is " + fixedUpperBound);
                    if (!fixedUpperBound.equals(upperBound)) {
                        ((QueryItem)node.getData()).setUpperBound(fixedUpperBound);
                    }
                    break block6;
                }
                String fixedValue = this.getDateValueInDefaultFormat(mdrIdDatatype.getLatestMdr(), value);
                if (fixedValue.equals(value)) break block6;
                ((QueryItem)node.getData()).setValue(fixedValue);
                break block6;
            }
            for (TreeModel child : node.getChildren()) {
                this.reformatDateFromSlotFormat((TreeModel<QueryItem>)child);
            }
        }
    }

    public String getDateValueInSlotFormat(String mdrKey, String value) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        Validations validations = this.mdrClient.getDataElementValidations(mdrKey, languageCode);
        ArrayList slots = this.mdrClient.getDataElementSlots(mdrKey);
        if (validations.getDatatype().equalsIgnoreCase(DATATYPE_DATE)) {
            for (Slot slot : slots) {
                if (!slot.getSlotName().equalsIgnoreCase(SLOTNAME_JAVA_DATE_FORMAT)) continue;
                String targetDateFormat = slot.getSlotValue();
                if (targetDateFormat.equalsIgnoreCase(DEFAULT_DATE_FORMAT)) break;
                try {
                    return SamplyShareUtils.convertDateStringToString(value, DEFAULT_DATE_FORMAT, targetDateFormat, Locale.ENGLISH, Locale.ENGLISH);
                }
                catch (Exception e) {
                    logger.error("exception caught...returning value without change.", (Throwable)e);
                    break;
                }
            }
        }
        return value;
    }

    public String getDateValueInElementValidationFormatWithSourceFormatAutodiscovering(String mdrKey, String value) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        Validations validations = this.mdrClient.getDataElementValidations(mdrKey, languageCode);
        if (validations.getDatatype().equalsIgnoreCase(DATATYPE_DATE)) {
            EnumDateFormat enumDateFormat = EnumDateFormat.valueOf((String)validations.getValidationData());
            String targetDateFormat = DateFormats.getDatePattern(enumDateFormat);
            try {
                String resultDate;
                Date date = SamplyShareUtils.autodiscoverDate(value, Locale.ENGLISH);
                if (date != null && (resultDate = SamplyShareUtils.convertDateToString(date, targetDateFormat, Locale.ENGLISH)) != null) {
                    value = resultDate;
                }
            }
            catch (Exception e) {
                logger.error("exception caught...returning value without change.", (Throwable)e);
            }
        }
        return value;
    }

    public String getDateValueInDefaultFormat(String mdrKey, String value) {
        return this.getDateValueInDefaultFormat(mdrKey, value, false);
    }

    public String getDateValueInDefaultFormat(String mdrKey, String value, boolean setMissingToMaxInsteadOfMin) {
        try {
            String slotDateFormat = this.getJavaDateFormatSlot(mdrKey);
            if (slotDateFormat == null) {
                logger.debug("No Java date format slot found, returning unmodified value.");
                return value;
            }
            if (!slotDateFormat.equalsIgnoreCase(DEFAULT_DATE_FORMAT)) {
                logger.error("slot format is " + slotDateFormat);
                try {
                    if (setMissingToMaxInsteadOfMin) {
                        logger.error("Set to max!");
                        DateTime dt = DateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)slotDateFormat));
                        if (slotDateFormat.equalsIgnoreCase("yyyy")) {
                            logger.error("just year");
                            return dt.withDayOfMonth(31).withMonthOfYear(12).toString(DateTimeFormat.forPattern((String)DEFAULT_DATE_FORMAT));
                        }
                        if (slotDateFormat.contains("MM")) {
                            logger.error("just month and year");
                            return dt.withDayOfMonth(31).toString(DateTimeFormat.forPattern((String)DEFAULT_DATE_FORMAT));
                        }
                        logger.error("complete");
                        return dt.toString(DateTimeFormat.forPattern((String)DEFAULT_DATE_FORMAT));
                    }
                    logger.error("Set to min!");
                    return SamplyShareUtils.convertDateStringToString(value, slotDateFormat, DEFAULT_DATE_FORMAT, Locale.ENGLISH, Locale.ENGLISH);
                }
                catch (Exception e) {
                    logger.error("exception caught...returning unmodified value", (Throwable)e);
                }
            }
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
            logger.debug("Could not get slot value from mdr, returning unmodified value.");
        }
        return value;
    }

    private String getJavaDateFormatSlot(String mdrKey) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException {
        Validations validations = this.mdrClient.getDataElementValidations(mdrKey, languageCode);
        ArrayList slots = this.mdrClient.getDataElementSlots(mdrKey);
        if (validations.getDatatype().equalsIgnoreCase(DATATYPE_DATE)) {
            for (Slot slot : slots) {
                if (!slot.getSlotName().equalsIgnoreCase(SLOTNAME_JAVA_DATE_FORMAT)) continue;
                return slot.getSlotValue();
            }
        }
        return null;
    }
}

