/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import java.util.regex.PatternSyntaxException;

public class MdrIdDatatype {
    public static final String SEPARATOR = ":";
    public static final String LATEST_VERSION_WILDCARD_MDR = "latest";
    public static final String LATEST_VERSION_WILDCARD_CENTRAXX = "*";
    private static final String URN = "urn";
    private String namespace;
    private String datatype;
    private String id;
    private String version;

    public MdrIdDatatype(String urn) {
        if (!urn.startsWith(URN)) {
            throw new IllegalArgumentException("wrong prefix: " + urn);
        }
        try {
            String[] urnTokens = urn.split(SEPARATOR);
            if (urnTokens.length < 4 || urnTokens.length > 5) {
                throw new IllegalArgumentException("Invalid amount of tokens: " + urn);
            }
            this.namespace = urnTokens[1];
            this.datatype = urnTokens[2];
            this.id = urnTokens[3];
            this.version = urnTokens.length > 4 ? urnTokens[4] : "";
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException("Pattern Syntax Exception.", pse);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Number Format Exception.", nfe);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMajor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URN).append(SEPARATOR).append(this.namespace).append(SEPARATOR).append(this.datatype).append(SEPARATOR).append(this.id);
        return stringBuffer.toString();
    }

    public String getLatestMdr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URN).append(SEPARATOR).append(this.namespace).append(SEPARATOR).append(this.datatype).append(SEPARATOR).append(this.id).append(SEPARATOR).append(LATEST_VERSION_WILDCARD_MDR);
        return stringBuffer.toString();
    }

    public String getLatestCentraxx() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URN).append(SEPARATOR).append(this.namespace).append(SEPARATOR).append(this.datatype).append(SEPARATOR).append(this.id).append(SEPARATOR).append(LATEST_VERSION_WILDCARD_CENTRAXX);
        return stringBuffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MdrIdDatatype that = (MdrIdDatatype)o;
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        if (!this.datatype.equals(that.datatype)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.version != null ? this.version.equals(that.version) : that.version == null;
    }

    public boolean equalsIgnoreVersion(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MdrIdDatatype that = (MdrIdDatatype)o;
        if (!this.namespace.equals(that.namespace)) {
            return false;
        }
        if (!this.datatype.equals(that.datatype)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.datatype.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(URN).append(SEPARATOR).append(this.namespace).append(SEPARATOR).append(this.datatype).append(SEPARATOR).append(this.id).append(SEPARATOR).append(this.version);
        return stringBuffer.toString();
    }
}

