/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.utils;

import de.samply.config.util.FileFinderUtil;
import de.samply.share.common.utils.ProjectInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfig.class);
    private Properties props;
    private String errorMsg = null;
    private String configPath = null;
    private String configFilename;

    protected AbstractConfig(String configFilename, String ... fallbacks) {
        this.configFilename = configFilename;
        this.props = new Properties();
        try {
            File file = FileFinderUtil.findFile((String)configFilename, (String)ProjectInfo.INSTANCE.getProjectName(), (String[])fallbacks);
            logger.info("Reading config from file " + file.getAbsolutePath());
            FileInputStream configInputStream = new FileInputStream(file);
            this.props.load(configInputStream);
            configInputStream.close();
            logger.info("Config read successfully");
        }
        catch (IOException e) {
            this.errorMsg = "Error reading configuration file: " + e.getMessage();
            logger.error(this.errorMsg);
            throw new RuntimeException(this.errorMsg);
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String propKey) {
        return this.props.getProperty(propKey);
    }

    public boolean debugIsOn() {
        String debugMode = this.props.getProperty("debug");
        return debugMode != null && debugMode.equalsIgnoreCase("true");
    }

    protected void setProperty(String propKey, String val) {
        this.props.setProperty(propKey, val);
    }

    public String getConfigFileName() {
        return this.configFilename;
    }

    public String getConfigPath() {
        if (this.configPath == null) {
            try {
                this.configPath = FileFinderUtil.findFile((String)this.getConfigFileName(), (String)ProjectInfo.INSTANCE.getProjectName(), null).getParent();
            }
            catch (FileNotFoundException e) {
                logger.error("Could not find config file...");
                e.printStackTrace();
            }
        }
        return this.configPath;
    }
}

