/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.model.uiquerybuilder;

import de.samply.common.mdrclient.domain.EnumElementType;
import de.samply.share.common.model.uiquerybuilder.MenuItem;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuItemTreeManager {
    private static final String STYLE_CLASS_NOT_AVAILABLE_IN_LOCALE = "notAvailableInLocale";
    private static final String A_GROUP = "searchMdrGroup";
    private static final String I_FOLDER_OPEN = "fa fa-folder-open-o searchMdrGroupIcon";
    private static final String I_FOLDER_CLOSED = "fa fa-folder-o searchMdrGroupIcon";
    private static final String LI_ACTIVE = "active";
    private static Logger logger = LoggerFactory.getLogger(MenuItemTreeManager.class);

    private MenuItemTreeManager() {
    }

    public static void cleanMenuItemStyleClass(MenuItem menuItem) {
        if (menuItem != null) {
            menuItem.setStyleClassLi("");
            menuItem.setStyleClassI(I_FOLDER_CLOSED);
        }
    }

    public static void cleanMenuItemsStyleClass(List<MenuItem> menuItemList) {
        for (MenuItem i : menuItemList) {
            if (i == null) continue;
            MenuItemTreeManager.cleanMenuItemStyleClass(i);
            MenuItemTreeManager.cleanMenuItemsStyleClass(i.getChildren());
        }
    }

    public static void clearMenuItemChildren(MenuItem menuItem) {
        if (menuItem != null) {
            menuItem.getChildren().clear();
        }
    }

    public static void addMenuItem(MenuItem menuItem, MenuItem parent) {
        parent.getChildren().add(menuItem);
    }

    public static boolean isItemOpen(MenuItem menuItem) {
        return menuItem != null && menuItem.getStyleClassI().contains(I_FOLDER_OPEN);
    }

    public static void setItemAndParentsOpen(MenuItem menuItem) {
        if (menuItem != null) {
            menuItem.setStyleClassLi(LI_ACTIVE);
            menuItem.setStyleClassI(I_FOLDER_OPEN);
            MenuItemTreeManager.setItemAndParentsOpen(menuItem.getParent());
        }
    }

    public static MenuItem buildMenuItem(String mdrId, EnumElementType enumElementType, String designation, String definition, ArrayList<MenuItem> children, MenuItem parent) {
        return MenuItemTreeManager.buildMenuItem(mdrId, enumElementType, designation, definition, children, parent, null);
    }

    public static MenuItem buildMenuItem(String mdrId, EnumElementType enumElementType, String designation, String definition, ArrayList<MenuItem> children, MenuItem parent, String searchString) {
        MenuItem menuItem = null;
        switch (enumElementType) {
            case DATAELEMENTGROUP: {
                menuItem = new MenuItem(mdrId, designation, definition, enumElementType, children, "", A_GROUP, I_FOLDER_CLOSED, parent);
                break;
            }
            case DATAELEMENT: {
                menuItem = new MenuItem(mdrId, designation, definition, enumElementType, children, "", "", "", parent);
                break;
            }
            case RECORD: {
                menuItem = new MenuItem(mdrId, designation, definition, enumElementType, children, "", "", "", parent);
                break;
            }
            case CATALOGUEGROUP: {
                menuItem = new MenuItem(mdrId, designation, definition, enumElementType, children, "", A_GROUP, I_FOLDER_CLOSED, parent);
                break;
            }
            case CATALOGUEELEMENT: {
                menuItem = new MenuItem(mdrId, designation, definition, enumElementType, children, "", "", "", parent, searchString);
                break;
            }
        }
        return menuItem;
    }

    public static MenuItem getMenuItem(List<MenuItem> menuItems, String menuItemMdrId) {
        for (MenuItem i : menuItems) {
            if (i == null) continue;
            if (i.getMdrId().compareTo(menuItemMdrId) == 0) {
                return i;
            }
            MenuItem menuItem = null;
            menuItem = MenuItemTreeManager.getMenuItem(i.getChildren(), menuItemMdrId);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }
}

