/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.control.uiquerybuilder;

import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.Validations;
import de.samply.share.common.model.uiquerybuilder.EnumConjunction;
import de.samply.share.common.model.uiquerybuilder.EnumOperator;
import de.samply.share.common.model.uiquerybuilder.QueryItem;
import de.samply.share.common.utils.MdrDatatype;
import de.samply.share.common.utils.QueryTreeUtil;
import de.samply.share.model.common.Query;
import de.samply.share.utils.QueryConverter;
import de.samply.web.mdrfaces.MdrContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.xml.bind.JAXBException;
import org.omnifaces.model.tree.ListTreeModel;
import org.omnifaces.model.tree.TreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchController
implements Serializable {
    private static final long serialVersionUID = 585856018106743936L;
    private static final String CONJUNCTION_GROUP_ID = "conjunctionGroup";
    private static final List<String> operatorList;
    private static List<String> conjunctionList;
    protected TreeModel<QueryItem> queryTree;
    private transient Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private transient MdrClient mdrClient = MdrContext.getMdrContext().getMdrClient();
    private transient HtmlPanelGroup sortableItemPanel;

    public AbstractSearchController() {
        this.queryTree = new ListTreeModel();
        QueryItem rootGroup = new QueryItem();
        rootGroup.setConjunction(EnumConjunction.AND);
        rootGroup.setMdrId(CONJUNCTION_GROUP_ID);
        rootGroup.setRoot(true);
        this.queryTree.addChild((Object)rootGroup);
    }

    @PostConstruct
    public void init() {
        String serializedQuery = this.getSerializedQuery();
        if (this.getSerializedQuery() != null && !serializedQuery.isEmpty()) {
            this.restoreQuery();
        }
    }

    public List<String> getConjunctionList() {
        return conjunctionList;
    }

    public abstract String getSerializedQuery();

    public abstract void setSerializedQuery(String var1);

    public TreeModel<QueryItem> getQueryTree() {
        return this.queryTree;
    }

    public void setQueryTree(TreeModel<QueryItem> queryTree) {
        this.queryTree = queryTree;
    }

    public void addItemToQueryRoot() {
        String mdrId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mdrId");
        String searchString = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("searchString");
        TreeModel<QueryItem> node = this.queryTree;
        if (searchString != null && searchString.length() > 0) {
            TreeModel<QueryItem> catalogueEntry = QueryTreeUtil.conditionTypeStringToTreenode(searchString);
            for (TreeModel child : catalogueEntry.getChildren()) {
                node.addChildNode(child);
            }
        } else {
            QueryItem queryItem = new QueryItem();
            queryItem.setMdrId(mdrId);
            node.addChild((Object)queryItem);
        }
    }

    public void addItemToQueryGroup() {
        String mdrId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mdrId");
        String tmpId = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("tmpId");
        TreeModel<QueryItem> node = null;
        node = this.getNodeByTmpId(this.queryTree, tmpId);
        if (node == null) {
            this.logger.debug("No matching id found " + tmpId + " ...adding to root");
            node = this.queryTree;
        }
        node = this.getParentConjunctionGroup(node);
        String searchString = (String)FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("searchString");
        if (searchString != null && searchString.length() > 0) {
            TreeModel<QueryItem> catalogueEntry = QueryTreeUtil.conditionTypeStringToTreenode(searchString);
            for (TreeModel child : catalogueEntry.getChildren()) {
                node.addChildNode(child);
            }
        } else {
            QueryItem queryItem = new QueryItem();
            queryItem.setMdrId(mdrId);
            node.addChild((Object)queryItem);
        }
    }

    private TreeModel<QueryItem> getNodeByTmpId(TreeModel<QueryItem> node, String tmpId) {
        if (!node.isRoot() && ((QueryItem)node.getData()).getTempId().equalsIgnoreCase(tmpId)) {
            return node;
        }
        TreeModel<QueryItem> foundNode = null;
        List childNodes = node.getChildren();
        for (int i = 0; foundNode == null && i < childNodes.size(); ++i) {
            foundNode = this.getNodeByTmpId((TreeModel<QueryItem>)((TreeModel)childNodes.get(i)), tmpId);
        }
        return foundNode;
    }

    private TreeModel<QueryItem> getParentConjunctionGroup(TreeModel<QueryItem> node) {
        if (node.isRoot()) {
            return node;
        }
        if (((QueryItem)node.getData()).getMdrId() != null && ((QueryItem)node.getData()).getMdrId().equalsIgnoreCase(CONJUNCTION_GROUP_ID)) {
            return node;
        }
        return this.getParentConjunctionGroup((TreeModel<QueryItem>)node.getParent());
    }

    public void addChild(TreeModel<QueryItem> node, String mdrId) {
        QueryItem queryItem = new QueryItem();
        queryItem.setMdrId(mdrId);
        node.addChild((Object)queryItem);
    }

    public void clone(TreeModel<QueryItem> node) {
        QueryItem original = (QueryItem)node.getData();
        QueryItem clone = new QueryItem();
        clone.setMdrId(original.getMdrId());
        clone.setOperator(original.getOperator());
        node.getParent().addChild((Object)clone);
    }

    public void remove(TreeModel<QueryItem> node) {
        node.remove();
    }

    public abstract String onStoreAndRelease();

    public abstract String onSubmit();

    public HtmlPanelGroup getSortableItemPanel() {
        return this.sortableItemPanel;
    }

    public void setSortableItemPanel(HtmlPanelGroup sortableItemPanel) {
        this.sortableItemPanel = sortableItemPanel;
    }

    public List<String> getOperatorList() {
        return operatorList;
    }

    public List<String> getOperatorList(String mdrId) {
        MdrDatatype dataType;
        try {
            Validations validations = this.mdrClient.getDataElementValidations(mdrId, "en");
            dataType = MdrDatatype.get(validations.getDatatype());
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
            e.printStackTrace();
            dataType = null;
        }
        ArrayList<String> ops = new ArrayList<String>();
        ops.add(EnumOperator.EQUAL.toString());
        if (dataType == null) {
            ops.add(EnumOperator.NOT_EQUAL_TO.toString());
            ops.add(EnumOperator.GREATER.toString());
            ops.add(EnumOperator.GREATER_OR_EQUAL.toString());
            ops.add(EnumOperator.LESS_OR_EQUAL_THEN.toString());
            ops.add(EnumOperator.LESS_THEN.toString());
            ops.add(EnumOperator.BETWEEN.toString());
            ops.add(EnumOperator.LIKE.toString());
            ops.add(EnumOperator.IS_NOT_NULL.toString());
            ops.add(EnumOperator.IS_NULL.toString());
        } else {
            switch (dataType) {
                case FLOAT: 
                case INTEGER: 
                case DATE: 
                case TIME: 
                case DATETIME: {
                    ops.add(EnumOperator.NOT_EQUAL_TO.toString());
                    ops.add(EnumOperator.GREATER.toString());
                    ops.add(EnumOperator.GREATER_OR_EQUAL.toString());
                    ops.add(EnumOperator.LESS_OR_EQUAL_THEN.toString());
                    ops.add(EnumOperator.LESS_THEN.toString());
                    ops.add(EnumOperator.BETWEEN.toString());
                    break;
                }
                case STRING: {
                    ops.add(EnumOperator.NOT_EQUAL_TO.toString());
                    ops.add(EnumOperator.LIKE.toString());
                    break;
                }
            }
            if (dataType != MdrDatatype.BOOLEAN) {
                ops.add(EnumOperator.IS_NOT_NULL.toString());
                ops.add(EnumOperator.IS_NULL.toString());
            }
        }
        return ops;
    }

    public boolean isQueryTreeNonTrivial() {
        return this.queryTree.getChildCount() > 0 && this.queryTree.getChildren().get(0) != null && ((TreeModel)this.queryTree.getChildren().get(0)).getChildCount() > 0;
    }

    public void serializeQuery() {
        Query query = this.isQueryTreeNonTrivial() ? QueryTreeUtil.treeToQuery(this.queryTree) : new Query();
        String queryAsXml = "";
        try {
            queryAsXml = QueryConverter.queryToXml((Query)query);
        }
        catch (JAXBException e) {
            this.logger.error("JAXB Exception while trying to convert query to xml.");
            return;
        }
        this.setSerializedQuery(queryAsXml);
    }

    public void restoreQuery() {
        String serializedQuery = this.getSerializedQuery();
        if (serializedQuery != null && serializedQuery.length() > 0 && !serializedQuery.equalsIgnoreCase("null")) {
            this.logger.debug("restoring query and refreshing page. Serialized query is " + serializedQuery);
            this.queryTree = QueryTreeUtil.queryStringToTree(serializedQuery);
            if (this.queryTree.getChildCount() == 0) {
                this.logger.debug("Query Tree was empty. Adding Default Group.");
                QueryItem queryItem = new QueryItem();
                queryItem.setMdrId(CONJUNCTION_GROUP_ID);
                queryItem.setRoot(true);
                this.queryTree.addChild((Object)queryItem);
            }
        }
    }

    static {
        conjunctionList = new ArrayList<String>();
        conjunctionList.add(EnumConjunction.AND.toString());
        conjunctionList.add(EnumConjunction.OR.toString());
        operatorList = new ArrayList<String>();
        operatorList.add(EnumOperator.EQUAL.toString());
        operatorList.add(EnumOperator.GREATER.toString());
        operatorList.add(EnumOperator.GREATER_OR_EQUAL.toString());
        operatorList.add(EnumOperator.IS_NOT_NULL.toString());
        operatorList.add(EnumOperator.IS_NULL.toString());
        operatorList.add(EnumOperator.LESS_OR_EQUAL_THEN.toString());
        operatorList.add(EnumOperator.LESS_THEN.toString());
        operatorList.add(EnumOperator.LIKE.toString());
        operatorList.add(EnumOperator.NOT_EQUAL_TO.toString());
        operatorList.add(EnumOperator.BETWEEN.toString());
    }
}

